/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public enum HandCommand implements IEnumCommand
{
    ID((stack, level) -> TextHelper.copyText(Objects.requireNonNull(level.method_30349().method_30530(class_7924.field_41197).method_10221((Object)stack.method_7909())).toString())),
    STRING((stack, level) -> TextHelper.copyText(stack.toString())),
    INGREDIENT(HandCommand.fromCodec(MapCodecs.INGREDIENT.get(), (stack, level) -> class_1856.method_8101((class_1799[])new class_1799[]{stack}))),
    STACK_JSON(HandCommand.fromCodec(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack));

    private final ItemFormat format;

    private HandCommand(ItemFormat format) {
        this.format = format;
    }

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            ((class_2168)context.getSource()).method_9226(() -> this.format.formatItem(living.method_6047(), source.method_9225()), false);
        }
        return 1;
    }

    private static <T> ItemFormat fromCodec(Codec<T> codec, BiFunction<class_1799, class_3218, T> mapper) {
        return (stack, level) -> {
            if (stack.method_7960()) {
                return class_2561.method_43471((String)"commands.bookshelf.hand.error.not_air").method_27692(class_124.field_1061);
            }
            Object value = mapper.apply(stack, level);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)level.method_30349()), value).getOrThrow();
            return TextHelper.copyText(Constants.GSON_PRETTY.toJson(json));
        };
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        return CommandHelper.buildFromEnum("hand", HandCommand.class);
    }

    static interface ItemFormat {
        public class_2561 formatItem(class_1799 var1, class_3218 var2);
    }
}

