/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.InstanceEndec;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesHolderImpl
implements AccessoriesHolder,
InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MapCarrier EMPTY = new NbtMapCarrier(new class_2487());
    private final Map<String, AccessoriesContainer> slotContainers = new LinkedHashMap<String, AccessoriesContainer>();
    public final List<class_1799> invalidStacks = new ArrayList<class_1799>();
    protected final Map<AccessoriesContainer, Boolean> containersRequiringUpdates = new HashMap<AccessoriesContainer, Boolean>();
    private PlayerEquipControl equipControl = PlayerEquipControl.MUST_NOT_CROUCH;
    private boolean showAdvancedOptions = false;
    private boolean showUnusedSlots = false;
    private boolean showCosmetics = false;
    private int columnAmount = 1;
    private int widgetType = 2;
    private boolean showGroupFilter = false;
    private boolean mainWidgetPosition = true;
    private boolean sideWidgetPosition = false;
    private boolean showCraftingGrid = false;
    private MapCarrier carrier;
    protected boolean loadedFromTag = false;
    @Nullable
    private Map<String, AccessoriesContainer> validSlotContainers = null;
    @Nullable
    public AccessoriesHolderLookupCache lookupCache = null;
    private boolean isGroupFiltersOpen = true;
    private Set<String> filteredGroups = Set.of();
    private static final KeyedEndec<Map<String, AccessoriesContainer>> CONTAINERS_KEY = NbtEndec.COMPOUND.xmapWithContext((ctx, containersMap) -> {
        class_1309 entity = ((EntityAttribute)ctx.requireAttributeValue(EntityAttribute.ENTITY)).livingEntity();
        Map<String, AccessoriesContainer> slotContainers = ((ContainersAttribute)ctx.requireAttributeValue(ContainersAttribute.CONTAINERS)).slotContainers();
        List<class_1799> invalidStacks = ((InvalidStacksAttribute)ctx.requireAttributeValue(InvalidStacksAttribute.INVALID_STACKS)).invalidStacks();
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        for (String key : containersMap.method_10541()) {
            int i;
            class_2487 containerElement = containersMap.method_10562(key);
            if (containerElement.method_33133()) continue;
            if (slots.containsKey(key)) {
                AccessoriesContainer container = slotContainers.get(key);
                class_1277 prevAccessories = AccessoriesContainerImpl.copyContainerList(container.getAccessories());
                class_1277 prevCosmetics = AccessoriesContainerImpl.copyContainerList(container.getCosmeticAccessories());
                ((AccessoriesContainerImpl)container).read(new NbtMapCarrier(containerElement), (SerializationContext)ctx);
                if (prevAccessories.method_5439() <= container.getSize()) continue;
                for (i = container.getSize() - 1; i < prevAccessories.method_5439(); ++i) {
                    class_1799 prevCosmetic;
                    class_1799 prevStack = prevAccessories.method_5438(i);
                    if (!prevStack.method_7960()) {
                        invalidStacks.add(prevStack);
                    }
                    if ((prevCosmetic = prevCosmetics.method_5438(i)).method_7960()) continue;
                    invalidStacks.add(prevCosmetic);
                }
                continue;
            }
            List<class_1277> containers = AccessoriesContainerImpl.readContainers(new NbtMapCarrier(containerElement), ctx, AccessoriesContainerImpl.COSMETICS_KEY, AccessoriesContainerImpl.ITEMS_KEY);
            for (class_1277 simpleContainer : containers) {
                for (i = 0; i < simpleContainer.method_5439(); ++i) {
                    class_1799 stack = simpleContainer.method_5438(i);
                    if (stack.method_7960()) continue;
                    invalidStacks.add(stack);
                }
            }
        }
        return slotContainers;
    }, (ctx, containers) -> {
        class_2487 containerMap = new class_2487();
        containers.forEach((s, container) -> containerMap.method_10566(s, (class_2520)((NbtMapCarrier)class_156.method_654((Object)NbtMapCarrier.of(), innerCarrier -> ((AccessoriesContainerImpl)container).write((MapCarrier)innerCarrier, (SerializationContext)ctx))).compoundTag()));
        return containerMap;
    }).keyed("accessories_containers", HashMap::new);
    private static final KeyedEndec<PlayerEquipControl> EQUIP_CONTROL_KEY = Endec.forEnum(PlayerEquipControl.class).keyed("equip_control", (Object)PlayerEquipControl.MUST_CROUCH);
    private static final KeyedEndec<Boolean> SHOW_UNUSED_SLOTS_KEY = Endec.BOOLEAN.keyed("show_unused_slots", (Object)false);
    private static final KeyedEndec<Boolean> SHOW_COSMETICS_KEY = Endec.BOOLEAN.keyed("show_cosmetics", (Object)false);
    private static final KeyedEndec<Integer> COLUMN_AMOUNT_KEY = Endec.INT.keyed("column_amount", (Object)1);
    private static final KeyedEndec<Integer> WIDGET_TYPE_KEY = Endec.INT.keyed("widget_type", (Object)2);
    private static final KeyedEndec<Boolean> MAIN_WIDGET_POSITION = Endec.BOOLEAN.keyed("main_widget_position", (Object)true);
    private static final KeyedEndec<Boolean> SIDE_WIDGET_POSITION = Endec.BOOLEAN.keyed("side_widget_position", (Object)false);
    private static final KeyedEndec<Boolean> SHOW_GROUP_FILTER = Endec.BOOLEAN.keyed("show_group_filter", (Object)false);
    private static final KeyedEndec<Boolean> IS_GROUP_FILTERS_OPEN_KEY = Endec.BOOLEAN.keyed("is_group_filter_open", (Object)false);
    private static final KeyedEndec<Set<String>> FILTERED_GROUPS_KEY = Endec.STRING.setOf().keyed("filtered_groups", HashSet::new);
    private static final KeyedEndec<Boolean> SHOW_CRAFTING_GRID = Endec.BOOLEAN.keyed("cosmetics_shown", (Object)false);

    public static AccessoriesHolderImpl of() {
        AccessoriesHolderImpl holder = new AccessoriesHolderImpl();
        holder.loadedFromTag = true;
        holder.carrier = EMPTY;
        return holder;
    }

    @ApiStatus.Internal
    protected Map<String, AccessoriesContainer> getAllSlotContainers() {
        return this.slotContainers;
    }

    public void setValidTypes(Set<String> validTypes) {
        ImmutableMap.Builder validSlotContainers = ImmutableMap.builder();
        this.slotContainers.forEach((string, container) -> {
            if (validTypes.contains(container.getSlotName())) {
                validSlotContainers.put(string, container);
            }
        });
        this.validSlotContainers = validSlotContainers.build();
        if (this.lookupCache == null) {
            this.lookupCache = new AccessoriesHolderLookupCache(this);
        }
        this.lookupCache.clearCache();
    }

    @ApiStatus.Internal
    public Map<String, AccessoriesContainer> getSlotContainers() {
        return this.validSlotContainers != null ? this.validSlotContainers : this.getAllSlotContainers();
    }

    @Override
    @Nullable
    public AccessoriesHolderLookupCache getLookupCache() {
        return Accessories.config().useExperimentalCaching() ? this.lookupCache : null;
    }

    @Override
    public PlayerEquipControl equipControl() {
        return this.equipControl;
    }

    @Override
    public AccessoriesHolder equipControl(PlayerEquipControl value) {
        this.equipControl = value;
        return this;
    }

    @Override
    public boolean showUnusedSlots() {
        return this.showUnusedSlots;
    }

    @Override
    public AccessoriesHolder showUnusedSlots(boolean value) {
        this.showUnusedSlots = value;
        return this;
    }

    @Override
    public boolean cosmeticsShown() {
        return this.showCosmetics;
    }

    @Override
    public AccessoriesHolder cosmeticsShown(boolean value) {
        this.showCosmetics = value;
        return this;
    }

    @Override
    public int columnAmount() {
        return Math.max(this.columnAmount, 1);
    }

    @Override
    public AccessoriesHolder columnAmount(int value) {
        this.columnAmount = value;
        return this;
    }

    @Override
    public int widgetType() {
        return Math.max(this.widgetType, 1);
    }

    @Override
    public AccessoriesHolder widgetType(int value) {
        this.widgetType = value;
        return this;
    }

    @Override
    public boolean mainWidgetPosition() {
        return this.mainWidgetPosition;
    }

    @Override
    public AccessoriesHolder mainWidgetPosition(boolean value) {
        this.mainWidgetPosition = value;
        return this;
    }

    @Override
    public boolean showAdvancedOptions() {
        return this.showAdvancedOptions;
    }

    @Override
    public AccessoriesHolder showAdvancedOptions(boolean value) {
        this.showAdvancedOptions = value;
        return this;
    }

    @Override
    public boolean showGroupFilter() {
        return this.showGroupFilter;
    }

    @Override
    public AccessoriesHolder showGroupFilter(boolean value) {
        this.showGroupFilter = value;
        return this;
    }

    @Override
    public boolean isGroupFiltersOpen() {
        return this.isGroupFiltersOpen;
    }

    @Override
    public AccessoriesHolder isGroupFiltersOpen(boolean value) {
        this.isGroupFiltersOpen = value;
        return this;
    }

    @Override
    public Set<String> filteredGroups() {
        return this.filteredGroups;
    }

    @Override
    public AccessoriesHolder filteredGroups(Set<String> value) {
        this.filteredGroups = value;
        return this;
    }

    @Override
    public boolean sideWidgetPosition() {
        return this.sideWidgetPosition;
    }

    @Override
    public AccessoriesHolder sideWidgetPosition(boolean value) {
        this.sideWidgetPosition = value;
        return this;
    }

    @Override
    public boolean showCraftingGrid() {
        return this.showCraftingGrid;
    }

    @Override
    public AccessoriesHolder showCraftingGrid(boolean value) {
        this.showCraftingGrid = value;
        return this;
    }

    public void init(AccessoriesCapability capability) {
        class_1309 livingEntity = capability.entity();
        Map<String, SlotType> entitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (livingEntity instanceof class_1657 && entitySlots.isEmpty()) {
            LOGGER.warn("It seems the given player has no slots bound to it within a init call, is that desired?");
        }
        this.validSlotContainers = null;
        if (this.loadedFromTag) {
            entitySlots.forEach((s, slotType) -> this.slotContainers.putIfAbsent((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
            SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new EntityAttribute(livingEntity), RegistriesAttribute.of((class_5455)livingEntity.method_56673())});
            this.read(capability, livingEntity, this.carrier, ctx);
        } else {
            entitySlots.forEach((s, slotType) -> this.slotContainers.put((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
        }
        this.setValidTypes(entitySlots.keySet());
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        if (this.slotContainers.isEmpty()) {
            return;
        }
        carrier.put(ctx, CONTAINERS_KEY, this.slotContainers);
        carrier.put(ctx, EQUIP_CONTROL_KEY, (Object)this.equipControl);
        carrier.put(ctx, COLUMN_AMOUNT_KEY, (Object)this.columnAmount);
        carrier.put(ctx, WIDGET_TYPE_KEY, (Object)this.widgetType);
        carrier.put(ctx, MAIN_WIDGET_POSITION, (Object)this.mainWidgetPosition);
        carrier.put(ctx, SIDE_WIDGET_POSITION, (Object)this.sideWidgetPosition);
        carrier.put(ctx, SHOW_COSMETICS_KEY, (Object)this.showCosmetics);
        carrier.put(ctx, SHOW_UNUSED_SLOTS_KEY, (Object)this.showUnusedSlots);
        carrier.put(ctx, SHOW_GROUP_FILTER, (Object)this.showGroupFilter);
        carrier.put(ctx, IS_GROUP_FILTERS_OPEN_KEY, (Object)this.isGroupFiltersOpen);
        carrier.put(ctx, FILTERED_GROUPS_KEY, this.filteredGroups);
        carrier.put(ctx, SHOW_CRAFTING_GRID, (Object)this.showCraftingGrid);
    }

    public void read(class_1309 entity, MapCarrier carrier, SerializationContext ctx) {
        this.read(entity.accessoriesCapability(), entity, carrier, ctx);
    }

    public void read(AccessoriesCapability capability, class_1309 entity, MapCarrier carrier, SerializationContext ctx) {
        this.loadedFromTag = false;
        EndecUtils.dfuKeysCarrier(carrier, Map.of("AccessoriesContainers", "accessories_containers", "CosmeticsShown", "cosmetics_shown", "LinesShown", "lines_shown", "EquipControl", "equip_control"));
        carrier.getWithErrors(ctx.withAttributes(new SerializationAttribute.Instance[]{new ContainersAttribute(this.slotContainers), new InvalidStacksAttribute(this.invalidStacks)}), CONTAINERS_KEY);
        this.equipControl = (PlayerEquipControl)((Object)carrier.get(ctx, EQUIP_CONTROL_KEY));
        this.columnAmount = (Integer)carrier.get(ctx, COLUMN_AMOUNT_KEY);
        this.widgetType = (Integer)carrier.get(ctx, WIDGET_TYPE_KEY);
        this.mainWidgetPosition = (Boolean)carrier.get(ctx, MAIN_WIDGET_POSITION);
        this.sideWidgetPosition = (Boolean)carrier.get(ctx, SIDE_WIDGET_POSITION);
        this.showCosmetics = (Boolean)carrier.get(ctx, SHOW_COSMETICS_KEY);
        this.showUnusedSlots = (Boolean)carrier.get(ctx, SHOW_UNUSED_SLOTS_KEY);
        this.showGroupFilter = (Boolean)carrier.get(ctx, SHOW_GROUP_FILTER);
        this.isGroupFiltersOpen = (Boolean)carrier.get(ctx, IS_GROUP_FILTERS_OPEN_KEY);
        this.filteredGroups = (Set)carrier.get(ctx, FILTERED_GROUPS_KEY);
        this.showCraftingGrid = (Boolean)carrier.get(ctx, SHOW_CRAFTING_GRID);
        capability.clearCachedSlotModifiers();
        this.carrier = EMPTY;
        AccessoriesHolderLookupCache cache = this.getLookupCache();
        if (cache != null) {
            cache.clearCache();
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext context) {
        this.loadedFromTag = true;
        this.carrier = carrier;
    }

    private record EntityAttribute(class_1309 livingEntity) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<EntityAttribute> ENTITY = SerializationAttribute.withValue((String)"entity");

        public SerializationAttribute attribute() {
            return ENTITY;
        }

        public Object value() {
            return this;
        }
    }

    private record ContainersAttribute(Map<String, AccessoriesContainer> slotContainers) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContainersAttribute> CONTAINERS = SerializationAttribute.withValue((String)Accessories.translationKey("containers"));

        public SerializationAttribute attribute() {
            return CONTAINERS;
        }

        public Object value() {
            return this;
        }
    }

    private record InvalidStacksAttribute(List<class_1799> invalidStacks) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<InvalidStacksAttribute> INVALID_STACKS = SerializationAttribute.withValue((String)Accessories.translationKey("invalidStacks"));

        public SerializationAttribute attribute() {
            return INVALID_STACKS;
        }

        public Object value() {
            return this;
        }
    }
}

