/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Rounder;

public class ChopCounting {
    private static final int CACHE_SIZE = 1024;
    private static final int[] cache = new int[1024];
    private static int numCached = 1;
    private static final Rounder rounder = (Rounder)((Object)ConfigHandler.COMMON.chopCountRounding.get());
    private static final boolean canRequireMoreChopsThanBlocks = (Boolean)ConfigHandler.COMMON.canRequireMoreChopsThanBlocks.get();
    private static final ChopCountingAlgorithm algorithm = (ChopCountingAlgorithm)((Object)ConfigHandler.COMMON.chopCountingAlgorithm.get());

    public static int calculate(int support) {
        if (support < 1024) {
            if (numCached <= support) {
                while (numCached <= support) {
                    ChopCounting.cache[ChopCounting.numCached] = ChopCounting.recalculate(numCached);
                    ++numCached;
                }
            }
            return cache[support];
        }
        return ChopCounting.recalculate(support);
    }

    private static int recalculate(int support) {
        int count = Math.max(1, rounder.round(algorithm.calculate(support, rounder, canRequireMoreChopsThanBlocks)));
        return canRequireMoreChopsThanBlocks ? count : Math.min(support, count);
    }
}

