/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CustomMapData<C extends DirtyCounter, P> {
    public Type<P, ?> getType();

    default public boolean persistOnCopyOrLock() {
        return true;
    }

    default public boolean onItemUpdate(class_22 data, class_1297 entity) {
        return false;
    }

    @Nullable
    default public class_2561 onItemTooltip(class_22 data, class_1799 stack) {
        return null;
    }

    public C createDirtyCounter();

    public void load(class_2487 var1, class_7225.class_7874 var2);

    public void save(class_2487 var1, class_7225.class_7874 var2);

    public P createUpdatePatch(C var1);

    public void applyUpdatePatch(P var1);

    default public void setDirty(class_22 data, Consumer<C> dirtySetter) {
        Type<P, ?> type = this.getType();
        ((ExpandedMapData)data).ml$setCustomDataDirty(type, dirtySetter);
    }

    public record Type<P, T extends CustomMapData<?, P>>(class_2960 id, Supplier<T> factory, class_9139<? super class_9129, P> patchCodec) {
        public static final Codec<Type<?, ?>> CODEC = MapDataInternal.CUSTOM_MAP_DATA_TYPES;
        public static final class_9139<class_2540, Type<?, ?>> STREAM_CODEC = MapDataInternal.CUSTOM_MAP_DATA_TYPES.getStreamCodec();

        @NotNull
        public T get(class_22 mapData) {
            return (T)((ExpandedMapData)mapData).ml$getCustomData().get(this);
        }
    }

    public static abstract class Simple<O>
    implements CustomMapData<SimpleDirtyCounter, O> {
        protected O value;

        public Simple(O defaultValue) {
            this.value = defaultValue;
        }

        @Deprecated(forRemoval=true)
        public Simple() {
        }

        @Override
        public Type<O, ?> getType() {
            return null;
        }

        @Override
        public SimpleDirtyCounter createDirtyCounter() {
            return new SimpleDirtyCounter();
        }

        @Override
        public O createUpdatePatch(SimpleDirtyCounter dirtyCounter) {
            return this.value;
        }

        @Override
        public void applyUpdatePatch(O patch) {
            this.value = patch;
        }
    }

    public static class SimpleDirtyCounter
    implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void clearDirty() {
            this.dirty = false;
        }
    }

    public record DirtyDataPatch<P, D extends CustomMapData<?, P>>(Type<P, D> type, P patch) {
        public static final class_9139<class_9129, DirtyDataPatch<?, ?>> STREAM_CODEC = new class_9139<class_9129, DirtyDataPatch<?, ?>>(){

            public void encode(class_9129 buf, DirtyDataPatch<?, ?> dirtyData) {
                Type.STREAM_CODEC.encode((Object)buf, dirtyData.type);
                1.encodeTyped(buf, dirtyData);
            }

            private static <P> void encodeTyped(class_9129 buf, DirtyDataPatch<P, ?> dirtyData) {
                dirtyData.type.patchCodec().encode((Object)buf, dirtyData.patch);
            }

            public DirtyDataPatch<?, ?> decode(class_9129 buf) {
                Type type = (Type)Type.STREAM_CODEC.decode((Object)buf);
                return 1.decodeTyped(buf, type);
            }

            private static <P, D extends CustomMapData<?, P>> DirtyDataPatch<P, D> decodeTyped(class_9129 buf, Type<P, D> type) {
                Object decode = type.patchCodec().decode((Object)buf);
                return new DirtyDataPatch<Object, D>(type, decode);
            }
        };

        public void apply(Map<Type<?, ?>, CustomMapData<?, ?>> customData) {
            CustomMapData<?, ?> data = customData.get(this.type);
            data.applyUpdatePatch(this.patch);
        }
    }

    public static interface DirtyCounter {
        public boolean isDirty();

        public void clearDirty();
    }
}

