/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.BracketHandlers;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketValidators")
@Document(value="vanilla/api/BracketValidators")
public class BracketValidators {
    private BracketValidators() {
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod, boolean logError) {
        try {
            return bracketMethod.apply(tokens) != null;
        }
        catch (Exception e) {
            if (logError) {
                CommonLoggers.zenCode().error("Error validating BEP <{}:{}>", (Object)bracketName, (Object)tokens, (Object)e);
            }
            return false;
        }
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod) {
        return BracketValidators.validateBracket(bracketName, tokens, bracketMethod, true);
    }

    @ZenCodeType.Method
    @BracketValidator(value="block")
    public static boolean validateBlockBracket(String tokens) {
        return BracketValidators.validateBracket("block", tokens, BracketHandlers::getBlock);
    }

    @ZenCodeType.Method
    @BracketValidator(value="fluid")
    public static boolean validateFluidStack(String tokens) {
        return BracketValidators.validateBracket("fluid", tokens, BracketHandlers::getFluidStack);
    }

    @ZenCodeType.Method
    @BracketValidator(value="blockstate")
    public static boolean validateBlockStateMaterialBracket(String tokens) {
        String[] split = tokens.split(":");
        if (split.length > 4 || split.length < 2) {
            CommonLoggers.zenCode().error("Invalid bracket Syntax: <blockstate:{}>! Correct syntax is <blockstate:modid:block_name:properties> or <blockstate:modid:block_name>!", (Object)tokens);
            return false;
        }
        String resourceLocation = split[0] + ":" + split[1];
        if (class_2960.method_12829((String)resourceLocation) == null) {
            CommonLoggers.zenCode().error("Invalid Block name for Blockstate bracket. '{}' is not a valid resource location!", (Object)resourceLocation);
            return false;
        }
        String properties = split.length == 3 ? split[2] : "";
        class_2680 blockState = BracketHandlers.getBlockState(resourceLocation, properties);
        return blockState != null;
    }

    @ZenCodeType.Method
    @BracketValidator(value="mobeffect")
    public static boolean validateEffectBracket(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <effect:{}>! Syntax is <effect:modid:potionname>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("effect", tokens, BracketHandlers::getMobEffect);
    }

    @ZenCodeType.Method
    @BracketValidator(value="enchantment")
    public static boolean validateEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Enchantment bracket <enchantment:{}> is not lower-case!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CommonLoggers.zenCode().error("Could not get enchantment '{}': not a valid bracket handler, syntax is <enchantment:modid:name>", (Object)tokens);
            return false;
        }
        class_2960 key = class_2960.method_60655((String)split[0], (String)split[1]);
        if (!Services.REGISTRY.registryOrThrow(class_7924.field_41265).method_10250(key)) {
            CommonLoggers.zenCode().error("Could not get enchantment '{}': the enchantment isn't registered", (Object)tokens);
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="entitytype")
    public static boolean validateEntityType(String tokens) {
        if (class_2960.method_12829((String)tokens) == null) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <entitytype:{}>! Syntax is <entitytype:modid:entity_type_name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("entitytype", tokens, BracketHandlers::getEntityType);
    }

    @ZenCodeType.Method
    @BracketValidator(value="item")
    public static boolean validateItemBracket(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Item bracket <item:{}> is not lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CommonLoggers.zenCode().error("Could not get item with name: <item:{}>! Syntax is <item:modid:itemname>", (Object)tokens);
            return false;
        }
        class_2960 key = class_2960.method_60655((String)split[0], (String)split[1]);
        if (!class_7923.field_41178.method_10250(key)) {
            CommonLoggers.zenCode().error("Could not get item with name: <item:{}>! Item does not exist!", (Object)tokens);
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="profession")
    public static boolean validateProfessionBracket(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <profession:{}>! Syntax is <profession:modid:profession_name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("profession", tokens, BracketHandlers::getProfession);
    }

    @ZenCodeType.Method
    @BracketValidator(value="resource")
    public static boolean validateResourceBracket(String tokens) {
        return class_2960.method_12829((String)tokens) != null;
    }

    @ZenCodeType.Method
    @BracketValidator(value="soundevent")
    public static boolean validateSoundEvent(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <soundevent:{}>! Syntax is <soundevent:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("soundevent", tokens, BracketHandlers::getSoundEvent);
    }

    @ZenCodeType.Method
    @BracketValidator(value="targetingstrategy")
    public static boolean validateTargetingStrategy(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax <targetingstrategy:{}>! Syntax is <targetingstrategy:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("targetingstrategy", tokens, BracketHandlers::getTargetingStrategy);
    }

    @ZenCodeType.Method
    @BracketValidator(value="componenttype")
    public static boolean validateComponentType(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <componenttype:{}>! Syntax is <componenttype:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("componenttype", tokens, BracketHandlers::getComponentType);
    }

    @ZenCodeType.Method
    @BracketValidator(value="bannerpattern")
    public static boolean validateBannerPattern(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <bannerpattern:{}>! Syntax is <bannerpattern:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("bannerpattern", tokens, BracketHandlers::getBannerPattern);
    }

    @ZenCodeType.Method
    @BracketValidator(value="instrument")
    public static boolean validateInstrument(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <instrument:{}>! Syntax is <instrument:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("instrument", tokens, BracketHandlers::getInstrument);
    }

    @ZenCodeType.Method
    @BracketValidator(value="trimpattern")
    public static boolean validateTrimPattern(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <trimpattern:{}>! Syntax is <trimpattern:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("trimpattern", tokens, BracketHandlers::getTrimPattern);
    }

    @ZenCodeType.Method
    @BracketValidator(value="trimmaterial")
    public static boolean validateTrimMaterial(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <trimmaterial:{}>! Syntax is <trimmaterial:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("trimmaterial", tokens, BracketHandlers::getTrimMaterial);
    }

    @ZenCodeType.Method
    @BracketValidator(value="decoratedpotpattern")
    public static boolean validateDecoratedPotPattern(String tokens) {
        if (tokens.split(":").length != 2) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <decoratedpotpattern:{}>! Syntax is <decoratedpotpattern:modid:name>", (Object)tokens);
            return false;
        }
        return BracketValidators.validateBracket("decoratedpotpattern", tokens, BracketHandlers::getDecoratedPotPattern);
    }
}

