/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command;

import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.impl.command.CommandImpl;
import com.blamejared.crafttweaker.impl.command.type.HelpCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.TreeMap;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5250;

public final class CtCommands {
    private static final CtCommands INSTANCE = new CtCommands();
    private final Map<String, CommandImpl> commands = new TreeMap<String, CommandImpl>(String::compareTo);
    private final Map<String, CommandImpl> commandsView = Collections.unmodifiableMap(this.commands);
    private final Queue<ChildData> lazyData = new LinkedList<ChildData>();

    private CtCommands() {
    }

    public static CtCommands get() {
        return INSTANCE;
    }

    public void registerCommand(String id, class_5250 desc, ICommandRegistrationHandler.CommandBuilder builder) {
        if (this.commands.containsKey(id)) {
            throw new IllegalStateException("Duplicate root command " + id);
        }
        this.commands.put(id, new CommandImpl(id, desc, builder));
    }

    public void registerSubCommand(String parent, String id, class_5250 desc, ICommandRegistrationHandler.CommandBuilder builder) {
        CommandImpl parentCommand = this.commands.get(parent);
        if (parentCommand == null) {
            this.lazyData.add(new ChildData(parent, id, desc, builder));
            return;
        }
        parentCommand.registerSubCommand(new CommandImpl(id, desc, builder));
    }

    public void registerDump(String dumpId, class_5250 description, ICommandRegistrationHandler.CommandBuilder builder) {
        this.lazyData.add(new ChildData("dump", dumpId, description, builder));
    }

    public void finalizeCommands() {
        this.computeLazyData(this.lazyData);
    }

    public void registerCommandsTo(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        LiteralCommandNode root = class_2170.method_9247((String)"ct").build();
        LiteralArgumentBuilder aliasedRoot = class_2170.method_9247((String)"crafttweaker");
        dispatcher.getRoot().addChild((CommandNode)root);
        dispatcher.getRoot().addChild((CommandNode)((LiteralArgumentBuilder)aliasedRoot.redirect((CommandNode)root)).build());
        HelpCommand.registerCommandIfRequired(this);
        this.commands.forEach((s, command) -> this.registerCommandTo((LiteralCommandNode<class_2168>)root, (CommandImpl)command));
    }

    private void computeLazyData(Queue<ChildData> dataQueue) {
        while (!dataQueue.isEmpty()) {
            ChildData data = dataQueue.remove();
            CommandImpl parent = Objects.requireNonNull(this.commands.get(data.parent()), "Unknown parent command " + data.parent());
            if (parent.subCommands().containsKey(data.id())) {
                throw new IllegalArgumentException("Duplicated subcommand for parent " + parent.name() + ": " + data.id());
            }
            parent.registerSubCommand(new CommandImpl(data.id(), data.desc(), data.builder()));
        }
    }

    private void registerCommandTo(LiteralCommandNode<class_2168> root, CommandImpl command) {
        LiteralArgumentBuilder literalCommand = class_2170.method_9247((String)command.name());
        command.subCommands().forEach((name, subCommand) -> this.registerSubCommandTo((LiteralArgumentBuilder<class_2168>)literalCommand, (CommandImpl)subCommand));
        command.register((LiteralArgumentBuilder<class_2168>)literalCommand);
        root.addChild((CommandNode)literalCommand.build());
    }

    private void registerSubCommandTo(LiteralArgumentBuilder<class_2168> root, CommandImpl command) {
        LiteralArgumentBuilder literalCommand = class_2170.method_9247((String)command.name());
        command.subCommands().forEach((name, subCommand) -> this.registerSubCommandTo((LiteralArgumentBuilder<class_2168>)literalCommand, (CommandImpl)subCommand));
        command.register((LiteralArgumentBuilder<class_2168>)literalCommand);
        root.then((ArgumentBuilder)literalCommand);
    }

    public Map<String, CommandImpl> commands() {
        return this.commandsView;
    }

    private record ChildData(String parent, String id, class_5250 desc, ICommandRegistrationHandler.CommandBuilder builder) {
    }
}

