/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.helper.CraftingTableRecipeConflictChecker;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.RecipeUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.mojang.datafixers.util.Pair;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8786;

@IRecipeHandler.For(value=class_1869.class)
public final class ShapedRecipeHandler
implements IRecipeHandler<class_1869> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super class_1869> manager, class_5455 registryAccess, class_8786<class_1869> holder) {
        class_1869 recipe = (class_1869)holder.comp_1933();
        class_2371 ingredients = recipe.method_8117();
        return String.format("craftingTable.addShaped(%s, %s, %s);", StringUtil.quoteAndEscape(holder.comp_1932()), ItemStackUtil.getCommandString(recipe.method_8110((class_7225.class_7874)registryAccess)), IntStream.range(0, recipe.method_8158()).mapToObj(y -> IntStream.range(0, recipe.method_8150()).mapToObj(x -> (class_1856)ingredients.get(y * recipe.method_8150() + x)).map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_1869> manager, class_1869 firstRecipe, U secondRecipe) {
        return CraftingTableRecipeConflictChecker.checkConflicts(manager, firstRecipe, secondRecipe);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_1869> manager, class_5455 registryAccess, class_1869 recipe) {
        List<IIngredient> ingredients = recipe.method_8117().stream().map(IIngredient::fromIngredient).toList();
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.method_8112()).with(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY, recipe.method_45441()).with(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D, Pair.of((Object)recipe.method_8150(), (Object)recipe.method_8158())).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.method_8110((class_7225.class_7874)registryAccess))).build();
        return Optional.of(decomposedRecipe);
    }

    @Override
    public Optional<class_1869> recompose(IRecipeManager<? super class_1869> manager, class_5455 registryAccess, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        class_7710 category = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY);
        Pair<Integer, Integer> size = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        int width = (Integer)size.getFirst();
        int height = (Integer)size.getSecond();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid shape size: bounds must be positive but got " + String.valueOf(size));
        }
        if (width * height != ingredients.size()) {
            throw new IllegalArgumentException("Invalid shape size: incompatible with ingredients, got " + String.valueOf(size) + " with " + ingredients.size());
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        class_2371 recipeIngredients = ingredients.stream().map(IIngredient::asVanillaIngredient).collect(class_2371::method_10211, AbstractList::add, AbstractCollection::addAll);
        return Optional.of(new class_1869(group, category, RecipeUtil.createPattern((class_2371<class_1856>)recipeIngredients, width, height), output.getInternal()));
    }
}

