/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.item.event;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.group.CombatConfigGroup;
import com.github.thedeathlycow.frostiful.item.event.FrostResistanceArmorType;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialEvents;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialTags;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class FrostResistanceProvider
implements ArmorMaterialEvents.GetResistance {
    public double getValue(class_6880<class_1741> armorMaterial, class_1738.class_8051 armorType) {
        FrostResistanceLevel level = FrostResistanceLevel.forMaterial(armorMaterial);
        FrostResistanceArmorType type = FrostResistanceArmorType.forArmorType(armorType);
        CombatConfigGroup config = Frostiful.getConfig().combatConfig;
        return level != FrostResistanceLevel.DEFAULT ? type.getFrostResistance(level.getFrostResistanceMultiplier(config)) : Double.NaN;
    }

    public static enum FrostResistanceLevel {
        VERY_PROTECTIVE((class_6862<class_1741>)ArmorMaterialTags.VERY_RESISTANT_TO_COLD, CombatConfigGroup::getVeryProtectiveFrostResistanceMultiplier),
        PROTECTIVE((class_6862<class_1741>)ArmorMaterialTags.RESISTANT_TO_COLD, CombatConfigGroup::getProtectiveFrostResistanceMultiplier),
        HARMFUL((class_6862<class_1741>)ArmorMaterialTags.WEAK_TO_COLD, CombatConfigGroup::getHarmfulFrostResistanceMultiplier),
        VERY_HARMFUL((class_6862<class_1741>)ArmorMaterialTags.VERY_WEAK_TO_COLD, CombatConfigGroup::getVeryHarmfulFrostResistanceMultiplier),
        DEFAULT(material -> true, c -> Double.NaN);

        private final Predicate<class_6880<class_1741>> predicate;
        private final ToDoubleFunction<CombatConfigGroup> frostResistanceProvider;

        private FrostResistanceLevel(class_6862<class_1741> tag, ToDoubleFunction<CombatConfigGroup> frostResistanceProvider) {
            this((class_6880<class_1741> material) -> material.method_40220(tag), frostResistanceProvider);
        }

        private FrostResistanceLevel(Predicate<class_6880<class_1741>> predicate, ToDoubleFunction<CombatConfigGroup> frostResistanceProvider) {
            this.predicate = predicate;
            this.frostResistanceProvider = frostResistanceProvider;
        }

        public double getFrostResistanceMultiplier(CombatConfigGroup config) {
            return this.frostResistanceProvider.applyAsDouble(config);
        }

        public boolean appliesToMaterial(class_6880<class_1741> material) {
            return this.predicate.test(material);
        }

        public static FrostResistanceLevel forMaterial(class_6880<class_1741> material) {
            for (FrostResistanceLevel level : FrostResistanceLevel.values()) {
                if (!level.appliesToMaterial(material)) continue;
                return level;
            }
            return DEFAULT;
        }
    }
}

