/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.formatters;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3446;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class StatValueFormatter {
    public static final StatValueFormatter TIME = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"-");
        }

        @Override
        public final class_2561 format(int ticks) {
            return TextUtils.literal((String)class_3446.field_16979.format(ticks));
        }
    };
    public static final StatValueFormatter TIME_TICKS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"20/s");
        }

        @Override
        public final class_2561 format(int ticks) {
            return TextUtils.literal((String)Integer.toString(ticks));
        }
    };
    public static final StatValueFormatter TIME_MILLISECONDS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"ms");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(0.02)).method_27693(" ms");
        }
    };
    public static final StatValueFormatter TIME_SECONDS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"s");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(20)).method_27693(" s");
        }
    };
    public static final StatValueFormatter TIME_MINUTES = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"m");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(1200)).method_27693(" m");
        }
    };
    public static final StatValueFormatter TIME_HOURS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"h");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(72000)).method_27693(" h");
        }
    };
    public static final StatValueFormatter TIME_DAYS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"d");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(1728000)).method_27693(" d");
        }
    };
    public static final StatValueFormatter TIME_WEEKS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"w");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(12096000)).method_27693(" w");
        }
    };
    public static final StatValueFormatter TIME_YEARS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"y");
        }

        @Override
        public final class_2561 format(int ticks) {
            return StatValueFormatter.calc(ticks, new BigDecimal(631152000)).method_27693(" y");
        }
    };
    public static final StatValueFormatter TIME_HH_MM_SS_MS = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"hh:mm:ss.ms");
        }

        @Override
        public final class_2561 format(int ticks) {
            int TICKS_PER_SECOND = 20;
            int SECONDS_PER_MINUTE = 60;
            int MINUTES_PER_HOUR = 60;
            int totalSeconds = ticks / 20;
            int hours = totalSeconds / 3600;
            int minutes = totalSeconds % 3600 / 60;
            int seconds = totalSeconds % 60;
            int milliseconds = ticks % 20 * 50;
            String result = String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds);
            return TextUtils.literal((String)result);
        }
    };
    public static final StatValueFormatter DISTANCE = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"-");
        }

        @Override
        public final class_2561 format(int cm) {
            return TextUtils.literal((String)class_3446.field_16977.format(cm));
        }
    };
    public static final StatValueFormatter DISTANCE_CENTIMETER = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"cm");
        }

        @Override
        public final class_2561 format(int cm) {
            return TextUtils.literal((String)Integer.toString(cm)).method_27693(" cm");
        }
    };
    public static final StatValueFormatter DISTANCE_METER = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"m");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(100)).method_27693(" m");
        }
    };
    public static final StatValueFormatter DISTANCE_KILOMETER = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"km");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(100000)).method_27693(" km");
        }
    };
    public static final StatValueFormatter DISTANCE_INCH = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"in");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(2.54)).method_27693(" in");
        }
    };
    public static final StatValueFormatter DISTANCE_FOOT = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"ft");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(30.48)).method_27693(" ft");
        }
    };
    public static final StatValueFormatter DISTANCE_YARD = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"yd");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(91.44)).method_27693(" yd");
        }
    };
    public static final StatValueFormatter DISTANCE_MILE = new StatValueFormatter(){

        @Override
        public final class_2561 getDisplayName() {
            return TextUtils.literal((String)"mi");
        }

        @Override
        public final class_2561 format(int cm) {
            return StatValueFormatter.calc(cm, new BigDecimal(160934.4)).method_27693(" mi");
        }
    };

    public abstract class_2561 getDisplayName();

    public abstract class_2561 format(int var1);

    @ApiStatus.Internal
    private static final String fdn(String str) {
        str = str.length() > 7 ? str.substring(0, 7) : str;
        str = str.replaceAll("(\\.)?0*$", "");
        return str;
    }

    private static final class_5250 calc(int input, BigDecimal divisor) {
        BigDecimal num = new BigDecimal(input).divide(divisor, 5, RoundingMode.DOWN);
        return TextUtils.literal((String)StatValueFormatter.fdn(num.toString()));
    }

    static {
        String modId = BetterStats.getModID();
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"default"), (Object)TIME);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"ms"), (Object)TIME_MILLISECONDS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"s"), (Object)TIME_SECONDS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"m"), (Object)TIME_MINUTES);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"h"), (Object)TIME_HOURS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"d"), (Object)TIME_DAYS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"w"), (Object)TIME_WEEKS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"y"), (Object)TIME_YEARS);
        BSRegistries.STAT_TIME_FORMATTER.register(class_2960.method_60655((String)modId, (String)"hh_mm_ss_ms"), (Object)TIME_HH_MM_SS_MS);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"default"), (Object)DISTANCE);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"cm"), (Object)DISTANCE_CENTIMETER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"m"), (Object)DISTANCE_METER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"km"), (Object)DISTANCE_KILOMETER);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"in"), (Object)DISTANCE_INCH);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"ft"), (Object)DISTANCE_FOOT);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"yd"), (Object)DISTANCE_YARD);
        BSRegistries.STAT_DISTANCE_FORMATTER.register(class_2960.method_60655((String)modId, (String)"mi"), (Object)DISTANCE_MILE);
    }
}

