/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.BlazeEntityAccess;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1545;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5425;

public final class WildfireSummonBlazeTask
extends class_4097<WildfireEntity> {
    private class_1309 attackTarget;
    private int summonedBlazesCount;
    private static final int SUMMON_BLAZES_DURATION = 20;
    public static final int MIN_BLAZES_TO_BE_SUMMONED = 1;
    private static final int MAX_BLAZES_TO_BE_SUMMONED = 2;

    public WildfireSummonBlazeTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (Object)class_4141.field_18457), 20);
    }

    protected boolean shouldRun(class_3218 world, WildfireEntity wildfire) {
        class_1309 attackTarget = wildfire.method_18868().method_18904(class_4140.field_22355).orElse(null);
        if (attackTarget == null || !attackTarget.method_5805() || attackTarget instanceof class_1657 && (attackTarget.method_7325() || ((class_1657)attackTarget).method_7337()) || wildfire.getSummonedBlazesCount() == 2) {
            WildfireBrain.setSummonBlazeCooldown(wildfire);
            return false;
        }
        this.attackTarget = attackTarget;
        return true;
    }

    protected void run(class_3218 world, WildfireEntity wildfire, long time) {
        wildfire.method_18868().method_18875(class_4140.field_18445);
        wildfire.method_5942().method_6340();
        class_4215.method_19554((class_1309)wildfire, (class_1309)this.attackTarget);
        wildfire.method_5988().method_35111((class_1297)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        this.summonedBlazesCount = 0;
    }

    protected boolean shouldKeepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        return this.summonedBlazesCount == 0;
    }

    protected void keepRunning(class_3218 world, WildfireEntity wildfire, long time) {
        class_4215.method_19554((class_1309)wildfire, (class_1309)this.attackTarget);
        class_3218 serverWorld = (class_3218)wildfire.method_37908();
        int blazesToBeSummoned = Math.max(0, wildfire.method_59922().method_39332(1, 2) - wildfire.getSummonedBlazesCount());
        if (blazesToBeSummoned > 0) {
            wildfire.playSummonBlazeSound();
        }
        for (int i = 0; i < blazesToBeSummoned; ++i) {
            class_2338 blockPos = wildfire.method_24515().method_10069(-2 + wildfire.method_59922().method_43048(5), 1, -2 + wildfire.method_59922().method_43048(5));
            class_1545 blazeEntity = (class_1545)class_1299.field_6099.method_5883((class_1937)serverWorld);
            blazeEntity.method_5725(blockPos, 0.0f, 0.0f);
            blazeEntity.method_5980(this.attackTarget);
            ((BlazeEntityAccess)blazeEntity).friendsandfoes_setWildfire(wildfire);
            blazeEntity.method_5943((class_5425)serverWorld, serverWorld.method_8404(blockPos), class_3730.field_16471, null);
            serverWorld.method_30771((class_1297)blazeEntity);
            ++this.summonedBlazesCount;
            wildfire.setSummonedBlazesCount(wildfire.getSummonedBlazesCount() + 1);
        }
    }

    protected void finishRunning(class_3218 world, WildfireEntity wildfire, long time) {
        WildfireBrain.setSummonBlazeCooldown(wildfire);
    }
}

