/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.util;

import io.wispforest.owo.registration.annotations.AssignedName;
import io.wispforest.owo.registration.annotations.IterationIgnored;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <C> C tryInstantiateWithNoArgs(Class<C> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException((e instanceof NoSuchMethodException ? "No zero-args constructor defined on class " : "Could not instantiate class ") + String.valueOf(clazz), e);
        }
    }

    public static <C> C instantiate(Constructor<C> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Wrapped object creation failure, look below for reason", e);
        }
    }

    public static <C> Constructor<C> getNoArgsConstructor(Class<C> clazz) {
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class " + clazz.getName() + " does not declare a zero-args constructor", e);
        }
    }

    public static <C, F> void iterateAccessibleStaticFields(Class<C> clazz, Class<F> targetFieldType, FieldConsumer<F> fieldConsumer) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null || !targetFieldType.isAssignableFrom(value.getClass()) || field.isAnnotationPresent(IterationIgnored.class)) continue;
            fieldConsumer.accept(value, ReflectionUtils.getFieldName(field), field);
        }
    }

    public static String getFieldName(Field field) {
        String fieldId = field.getName().toLowerCase(Locale.ROOT);
        if (field.isAnnotationPresent(AssignedName.class)) {
            fieldId = field.getAnnotation(AssignedName.class).value();
        }
        return fieldId;
    }

    public static void forApplicableSubclasses(Class<?> parent, Class<?> targetType, Consumer<Class<?>> action) {
        for (Class<?> subclass : parent.getDeclaredClasses()) {
            if (!targetType.isAssignableFrom(subclass)) continue;
            action.accept(subclass);
        }
    }

    public static void requireZeroArgsConstructor(Class<?> clazz, Function<String, String> reasonFormatter) {
        boolean found = false;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException(reasonFormatter.apply(clazz.getName()));
        }
    }

    public static String getCallingClassName(int depth) {
        return StackWalker.getInstance().walk(s -> s.skip(depth).map(StackWalker.StackFrame::getClassName).findFirst()).orElse("<unknown>");
    }

    @Nullable
    public static Class<?> getTypeArgument(Type type, int index) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        if (index > typeArgs.length - 1) {
            return null;
        }
        Type typeArgument = typeArgs[index];
        if (!(typeArgument instanceof Class)) {
            return null;
        }
        Class typeClass = (Class)typeArgument;
        return typeClass;
    }

    @FunctionalInterface
    public static interface FieldConsumer<F> {
        public void accept(F var1, String var2, Field var3);
    }
}

