/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientCraftTweakerBase;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.expand.ExpandItemTag;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class IngredientConverter {
    public static IIngredient fromIngredient(class_1856 ingredient) {
        if (ingredient == class_1856.field_9017) {
            return IngredientConverter.empty();
        }
        class_1856 class_18562 = ingredient;
        if (class_18562 instanceof IngredientCraftTweakerBase) {
            IngredientCraftTweakerBase base = (IngredientCraftTweakerBase)class_18562;
            return base.getCrTIngredient();
        }
        if (Services.PLATFORM.isCustomIngredient(ingredient)) {
            return new IIngredientList((IIngredient[])Services.PLATFORM.getCustomIngredientItems(ingredient).map(IItemStack::of).toArray(IIngredient[]::new));
        }
        return IngredientConverter.fromIItemLists(((AccessIngredient)ingredient).crafttweaker$getValues());
    }

    private static IIngredient fromIItemLists(class_1856.class_1859 ... itemLists) {
        IIngredient[] ingredients = (IIngredient[])Arrays.stream(itemLists).map(IngredientConverter::fromIItemList).filter(IngredientConverter::notEmptyStack).toArray(IIngredient[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromIItemList(class_1856.class_1859 value) {
        if (value instanceof class_1856.class_1858) {
            return IngredientConverter.fromTagList((class_1856.class_1858)value);
        }
        IIngredient[] ingredients = (IItemStack[])value.method_8108().stream().filter(stack -> !stack.method_7960()).map(IItemStack::of).toArray(IItemStack[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromTagList(class_1856.class_1858 value) {
        class_2960 location = value.comp_1931().comp_327();
        return CraftTweakerTagRegistry.INSTANCE.findKnownManager(class_7924.field_41197).map(mcTags -> mcTags.tag(location)).map(ExpandItemTag::asIIngredient).orElseThrow(() -> new RuntimeException("Error while converting ingredient: '" + String.valueOf(value) + "' to an IIngredient!"));
    }

    private static IIngredient empty() {
        return IIngredientEmpty.INSTANCE;
    }

    private static IIngredient mergeIngredients(IIngredient ... ingredients) {
        if (ingredients.length == 0) {
            return IngredientConverter.empty();
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IIngredientList(ingredients);
    }

    private static boolean notEmptyStack(IIngredient iIngredient) {
        return !(iIngredient instanceof IItemStack) || !iIngredient.isEmpty();
    }
}

