/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.util;

import com.google.gson.annotations.SerializedName;
import fonnymunkey.simplehats.Constants;
import java.util.Date;
import net.minecraft.class_1814;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class HatEntry {
    public static final HatDyeSettings DYE_NONE = new HatDyeSettings(false, 0);
    public static final HatParticleSettings PARTICLE_NONE = new HatParticleSettings(false, "minecraft:heart", 0.0f, HatParticleSettings.HatParticleMovement.TRAILING_FULL);
    @SerializedName(value="name")
    private String hatName;
    @SerializedName(value="rarity")
    private class_1814 hatRarity;
    @SerializedName(value="weight")
    private int hatWeight;
    @SerializedName(value="variants")
    private int variantRange;
    @SerializedName(value="season")
    private HatSeason hatSeason;
    @SerializedName(value="Dye Settings")
    private HatDyeSettings hatDyeSettings;
    @SerializedName(value="Particle Settings")
    private HatParticleSettings hatParticleSettings;

    public HatEntry(String name) {
        this(name, class_1814.field_8906, 0, 0, DYE_NONE, PARTICLE_NONE, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight) {
        this(name, rarity, weight, 0, DYE_NONE, PARTICLE_NONE, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange) {
        this(name, rarity, weight, variantRange, DYE_NONE, PARTICLE_NONE, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatDyeSettings dye) {
        this(name, rarity, weight, variantRange, dye, PARTICLE_NONE, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatParticleSettings particle) {
        this(name, rarity, weight, variantRange, DYE_NONE, particle, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatSeason season) {
        this(name, rarity, weight, variantRange, DYE_NONE, PARTICLE_NONE, season);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatDyeSettings dye, HatParticleSettings particle) {
        this(name, rarity, weight, variantRange, dye, particle, HatSeason.NONE);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatDyeSettings dye, HatSeason season) {
        this(name, rarity, weight, variantRange, dye, PARTICLE_NONE, season);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatParticleSettings particle, HatSeason season) {
        this(name, rarity, weight, variantRange, DYE_NONE, particle, season);
    }

    public HatEntry(String name, class_1814 rarity, int weight, int variantRange, HatDyeSettings dye, HatParticleSettings particle, HatSeason season) {
        this.hatName = name;
        this.hatRarity = rarity;
        this.hatWeight = Math.max(0, weight);
        this.variantRange = Math.max(0, variantRange);
        this.hatDyeSettings = dye;
        this.hatParticleSettings = particle;
        this.hatSeason = season;
    }

    public String getHatName() {
        return this.hatName;
    }

    public class_1814 getHatRarity() {
        return this.hatRarity;
    }

    public int getHatWeight() {
        return this.hatWeight;
    }

    public int getHatVariantRange() {
        return this.variantRange;
    }

    public HatDyeSettings getHatDyeSettings() {
        return this.hatDyeSettings;
    }

    public HatParticleSettings getHatParticleSettings() {
        return this.hatParticleSettings;
    }

    public HatSeason getHatSeason() {
        return this.hatSeason;
    }

    public void validateDeserializedEntry() {
        if (this.hatRarity == null) {
            this.hatRarity = class_1814.field_8906;
        }
        this.hatWeight = Math.max(0, this.hatWeight);
        this.variantRange = Math.max(0, this.variantRange);
        if (this.hatDyeSettings == null) {
            this.hatDyeSettings = DYE_NONE;
        }
        if (this.hatParticleSettings == null) {
            this.hatParticleSettings = PARTICLE_NONE;
        } else {
            this.hatParticleSettings.validateParticleSettings();
        }
        if (this.hatSeason == null) {
            this.hatSeason = HatSeason.NONE;
        }
    }

    public static class HatDyeSettings {
        @SerializedName(value="enabled")
        private boolean useDye;
        @SerializedName(value="decimal color")
        private int defaultColor;

        public HatDyeSettings(boolean useDye, int defaultColor) {
            this.useDye = useDye;
            this.defaultColor = defaultColor;
        }

        public boolean getUseDye() {
            return this.useDye;
        }

        public int getColorCode() {
            return this.defaultColor;
        }
    }

    public static class HatParticleSettings {
        @SerializedName(value="enabled")
        private boolean useParticle;
        @SerializedName(value="name")
        private String particleTypeString;
        @SerializedName(value="frequency")
        private float particleFrequency;
        @SerializedName(value="movement")
        private HatParticleMovement particleMovement;
        private transient class_2396<?> particleTypeParsed = class_2398.field_11201;

        public HatParticleSettings(boolean useParticle, String particleTypeString, float particleFrequency, HatParticleMovement particleMovement) {
            this.useParticle = useParticle;
            this.particleTypeString = particleTypeString;
            this.particleFrequency = particleFrequency;
            this.particleMovement = particleMovement;
            this.parseParticleString();
        }

        public boolean getUseParticles() {
            return this.useParticle;
        }

        public class_2396<?> getParticleType() {
            return this.particleTypeParsed;
        }

        public float getParticleFrequency() {
            return this.particleFrequency;
        }

        public HatParticleMovement getParticleMovement() {
            return this.particleMovement;
        }

        public void validateParticleSettings() {
            if (this.particleTypeString.isEmpty()) {
                this.particleTypeString = "minecraft:heart";
            }
            if (this.particleMovement == null) {
                this.particleMovement = HatParticleMovement.TRAILING_FULL;
            }
            this.parseParticleString();
        }

        private void parseParticleString() {
            class_2960 location = class_2960.method_12829((String)this.particleTypeString);
            this.particleTypeParsed = location != null ? (class_2396)class_7923.field_41180.method_10223(location) : null;
            if (this.particleTypeParsed == null) {
                Constants.LOG.error("Particle type \"" + this.particleTypeString + "\" failed to parse, setting default.");
                this.particleTypeParsed = class_2398.field_11201;
            }
        }

        public static enum HatParticleMovement {
            TRAILING_HEAD,
            TRAILING_FEET,
            TRAILING_FULL;

        }
    }

    public static enum HatSeason {
        EASTER{

            @Override
            public boolean compareDate(int date) {
                if (easterDayMin == 0 || easterDayMax == 0) {
                    int n;
                    int k;
                    int c;
                    int j;
                    int e;
                    int r;
                    int m;
                    int g;
                    int d;
                    int b;
                    int year = new Date().getYear();
                    int a = year % 19;
                    int h = (19 * a + (b = year / 100) - (d = b / 4) - (g = (8 * b + 13) / 25) + 15) % 30;
                    int p = (h - (m = (a + 11 * h) / 319) + (r = (2 * (e = b % 4) + 2 * (j = (c = year % 100) / 4) - (k = c % 4) - h + m + 32) % 7) + (n = (h - m + r + 90) / 25) + 19) % 32;
                    easterDayMin = p - 7 <= 0 ? (n - 1) * 100 + (p + 24) : n * 100 + (p - 7);
                    easterDayMax = p + 7 >= 31 ? (n + 1) * 100 + (p - 24) : n * 100 + (p + 7);
                }
                return date >= easterDayMin && date <= easterDayMax;
            }
        }
        ,
        SUMMER{

            @Override
            public boolean compareDate(int date) {
                return date >= 627 && date <= 711;
            }
        }
        ,
        HALLOWEEN{

            @Override
            public boolean compareDate(int date) {
                return date >= 1017 && date <= 1031;
            }
        }
        ,
        FESTIVE{

            @Override
            public boolean compareDate(int date) {
                return date >= 1217 && date <= 1231;
            }
        }
        ,
        NONE{

            @Override
            public boolean compareDate(int date) {
                return true;
            }
        };

        private static int easterDayMin;
        private static int easterDayMax;
        private static HatSeason cachedSeason;
        private static int cachedDay;

        public static HatSeason getSeason() {
            int cachedDayPre = cachedDay;
            int date = HatSeason.convertDate();
            if (cachedDayPre != cachedDay) {
                for (HatSeason season : HatSeason.values()) {
                    if (season.equals((Object)NONE) || !season.compareDate(date)) continue;
                    cachedSeason = season;
                    break;
                }
            }
            return cachedSeason;
        }

        public abstract boolean compareDate(int var1);

        private static int convertDate() {
            Date date = new Date();
            cachedDay = date.getDate();
            return (date.getMonth() + 1) * 100 + date.getDate();
        }

        static {
            easterDayMin = 0;
            easterDayMax = 0;
            cachedSeason = NONE;
            cachedDay = 0;
        }
    }
}

