/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.event;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.servux.interfaces.IPlayerListener;
import fi.dy.masa.servux.interfaces.IPlayerManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public class PlayerHandler
implements IPlayerManager {
    private static final PlayerHandler INSTANCE = new PlayerHandler();
    private final List<IPlayerListener> handlers = new ArrayList<IPlayerListener>();

    public static IPlayerManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerPlayerHandler(IPlayerListener handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    @Override
    public void unregisterPlayerHandler(IPlayerListener handler) {
        this.handlers.remove(handler);
    }

    @ApiStatus.Internal
    public void onClientConnect(SocketAddress addr, GameProfile profile, @Nullable class_2561 result) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onClientConnect(addr, profile, result);
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerJoin(SocketAddress addr, GameProfile profile, class_3222 player) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onPlayerJoin(addr, profile, player);
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerRespawn(class_3222 newPlayer, class_3222 oldPlayer) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onPlayerRespawn(newPlayer, oldPlayer);
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerOp(GameProfile profile, UUID uuid, @Nullable class_3222 player) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onPlayerOp(profile, uuid, player);
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerDeOp(GameProfile profile, UUID uuid, @Nullable class_3222 player) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onPlayerDeOp(profile, uuid, player);
            }
        }
    }

    @ApiStatus.Internal
    public void onPlayerLeave(class_3222 player) {
        if (!this.handlers.isEmpty()) {
            for (IPlayerListener handler : this.handlers) {
                handler.onPlayerLeave(player);
            }
        }
    }
}

