/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.packet.ServuxHudHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ServuxHudPacket
implements IServerPayloadData {
    private Type packetType;
    private class_2487 nbt;
    private class_2540 buffer;
    public static final int PROTOCOL_VERSION = 1;

    private ServuxHudPacket(Type type) {
        this.packetType = type;
        this.nbt = new class_2487();
        this.clearPacket();
    }

    public static ServuxHudPacket MetadataRequest(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_METADATA_REQUEST);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket MetadataResponse(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_METADATA);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket SpawnRequest(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_SPAWN_DATA_REQUEST);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket SpawnResponse(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_SPAWN_DATA);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket WeatherTick(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_WEATHER_TICK);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket RecipeManagerRequest(@Nullable class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_RECIPE_MANAGER_REQUEST);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket ResponseS2CStart(@Nonnull class_2487 nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_NBT_RESPONSE_START);
        packet.nbt.method_10543(nbt);
        return packet;
    }

    public static ServuxHudPacket ResponseS2CData(@Nonnull class_2540 buffer) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_NBT_RESPONSE_DATA);
        packet.buffer = buffer;
        packet.nbt = new class_2487();
        return packet;
    }

    private void clearPacket() {
        if (this.buffer != null) {
            this.buffer.method_52931();
            this.buffer = new class_2540(Unpooled.buffer());
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getPacketType() {
        return this.packetType.get();
    }

    @Override
    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.method_33133()) {
            total += this.nbt.method_47988();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public class_2487 getCompound() {
        return this.nbt;
    }

    public class_2540 getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.method_33133();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    @Override
    public void toPacket(class_2540 output) {
        output.method_10804(this.packetType.get());
        switch (this.packetType.ordinal()) {
            case 7: {
                try {
                    output.method_52975(this.buffer.readBytes(this.buffer.readableBytes()));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#toPacket: error writing buffer data to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                try {
                    output.method_10794((class_2520)this.nbt);
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Servux.logger.error("ServuxHudPacket#toPacket: Unknown packet type!");
            }
        }
    }

    @Nullable
    public static ServuxHudPacket fromPacket(class_2540 input) {
        int i = input.method_10816();
        Type type = ServuxHudPacket.getType(i);
        if (type == null) {
            Servux.logger.warn("ServuxHudPacket#fromPacket: invalid packet type received");
            return null;
        }
        switch (type.ordinal()) {
            case 7: {
                try {
                    return ServuxHudPacket.ResponseS2CData(new class_2540(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading S2C Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 1: {
                try {
                    return ServuxHudPacket.MetadataRequest(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Metadata Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 0: {
                try {
                    return ServuxHudPacket.MetadataResponse(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Metadata Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 3: {
                try {
                    return ServuxHudPacket.SpawnRequest(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Spawn Data Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 2: {
                try {
                    return ServuxHudPacket.SpawnResponse(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Spawn Data Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 4: {
                try {
                    return ServuxHudPacket.WeatherTick(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Weather Tick from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 5: {
                try {
                    return ServuxHudPacket.RecipeManagerRequest(input.method_10798());
                }
                catch (Exception e) {
                    Servux.logger.error("ServuxHudPacket#fromPacket: error reading Recipe Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            default: {
                Servux.logger.error("ServuxHudPacket#fromPacket: Unknown packet type!");
            }
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.nbt != null && !this.nbt.method_33133()) {
            this.nbt = new class_2487();
        }
        this.clearPacket();
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_C2S_METADATA_REQUEST(2),
        PACKET_S2C_SPAWN_DATA(3),
        PACKET_C2S_SPAWN_DATA_REQUEST(4),
        PACKET_S2C_WEATHER_TICK(5),
        PACKET_C2S_RECIPE_MANAGER_REQUEST(6),
        PACKET_S2C_NBT_RESPONSE_START(10),
        PACKET_S2C_NBT_RESPONSE_DATA(11);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxHudPacket data) implements class_8710
    {
        public static final class_8710.class_9154<Payload> ID = new class_8710.class_9154(ServuxHudHandler.CHANNEL_ID);
        public static final class_9139<class_2540, Payload> CODEC = class_8710.method_56484(Payload::write, Payload::new);

        public Payload(class_2540 input) {
            this(ServuxHudPacket.fromPacket(input));
        }

        private void write(class_2540 output) {
            this.data.toPacket(output);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

