/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.levelz.level.PlayerSkill;
import net.levelz.level.Skill;
import net.levelz.network.packet.LevelPacket;
import net.levelz.network.packet.PlayerSkillSyncPacket;
import net.levelz.network.packet.RestrictionPacket;
import net.levelz.network.packet.SkillSyncPacket;
import net.levelz.network.packet.StatPacket;
import net.levelz.screen.LevelScreen;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class LevelClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(SkillSyncPacket.PACKET_ID, (payload, context) -> {
            List<Integer> skillIds = payload.skillIds();
            List<String> skillKeys = payload.skillKeys();
            List<Integer> skillMaxLevels = payload.skillMaxLevels();
            List<SkillSyncPacket.SkillAttributesRecord> skillAttributes = payload.skillAttributes();
            SkillSyncPacket.SkillBonusesRecord skillBonuses = payload.skillBonuses();
            context.client().execute(() -> {
                int i;
                LevelManager levelManager = ((LevelManagerAccess)context.player()).getLevelManager();
                LevelManager.SKILLS.clear();
                for (i = 0; i < skillIds.size(); ++i) {
                    Skill skill = new Skill((Integer)skillIds.get(i), (String)skillKeys.get(i), (Integer)skillMaxLevels.get(i), ((SkillSyncPacket.SkillAttributesRecord)skillAttributes.get(i)).skillAttributes());
                    LevelManager.SKILLS.put((Integer)skillIds.get(i), skill);
                    if (levelManager.getPlayerSkills().containsKey(skillIds.get(i))) continue;
                    PlayerSkill playerSkill = new PlayerSkill((Integer)skillIds.get(i), 0);
                    levelManager.getPlayerSkills().put((Integer)skillIds.get(i), playerSkill);
                }
                LevelManager.BONUSES.clear();
                for (i = 0; i < skillBonuses.skillBonuses().size(); ++i) {
                    String bonusKey = skillBonuses.skillBonuses().get(i).getKey();
                    LevelManager.BONUSES.put(bonusKey, skillBonuses.skillBonuses().get(i));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(PlayerSkillSyncPacket.PACKET_ID, (payload, context) -> {
            List<Integer> playerSkillIds = payload.playerSkillIds();
            List<Integer> playerSkillLevels = payload.playerSkillLevels();
            context.client().execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)context.player()).getLevelManager();
                for (int i = 0; i < playerSkillIds.size(); ++i) {
                    levelManager.setSkillLevel((Integer)playerSkillIds.get(i), (Integer)playerSkillLevels.get(i));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(LevelPacket.PACKET_ID, (payload, context) -> {
            int overallLevel = payload.overallLevel();
            int skillPoints = payload.skillPoints();
            int totalLevelExperience = payload.totalLevelExperience();
            float levelProgress = payload.levelProgress();
            context.client().execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)context.player()).getLevelManager();
                levelManager.setOverallLevel(overallLevel);
                levelManager.setSkillPoints(skillPoints);
                levelManager.setTotalLevelExperience(totalLevelExperience);
                levelManager.setLevelProgress(levelProgress);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(RestrictionPacket.PACKET_ID, (payload, context) -> {
            RestrictionPacket.RestrictionRecord blockRestrictions = payload.blockRestrictions();
            RestrictionPacket.RestrictionRecord craftingRestrictions = payload.craftingRestrictions();
            RestrictionPacket.RestrictionRecord entityRestrictions = payload.entityRestrictions();
            RestrictionPacket.RestrictionRecord itemRestrictions = payload.itemRestrictions();
            RestrictionPacket.RestrictionRecord miningRestrictions = payload.miningRestrictions();
            RestrictionPacket.RestrictionRecord enchantmentRestrictions = payload.enchantmentRestrictions();
            context.client().execute(() -> {
                int i;
                LevelManager.BLOCK_RESTRICTIONS.clear();
                LevelManager.CRAFTING_RESTRICTIONS.clear();
                LevelManager.ENTITY_RESTRICTIONS.clear();
                LevelManager.ITEM_RESTRICTIONS.clear();
                LevelManager.MINING_RESTRICTIONS.clear();
                LevelManager.ENCHANTMENT_RESTRICTIONS.clear();
                for (i = 0; i < blockRestrictions.ids().size(); ++i) {
                    LevelManager.BLOCK_RESTRICTIONS.put(blockRestrictions.ids().get(i), blockRestrictions.restrictions().get(i));
                }
                for (i = 0; i < craftingRestrictions.ids().size(); ++i) {
                    LevelManager.CRAFTING_RESTRICTIONS.put(craftingRestrictions.ids().get(i), craftingRestrictions.restrictions().get(i));
                }
                for (i = 0; i < entityRestrictions.ids().size(); ++i) {
                    LevelManager.ENTITY_RESTRICTIONS.put(entityRestrictions.ids().get(i), entityRestrictions.restrictions().get(i));
                }
                for (i = 0; i < itemRestrictions.ids().size(); ++i) {
                    LevelManager.ITEM_RESTRICTIONS.put(itemRestrictions.ids().get(i), itemRestrictions.restrictions().get(i));
                }
                for (i = 0; i < miningRestrictions.ids().size(); ++i) {
                    LevelManager.MINING_RESTRICTIONS.put(miningRestrictions.ids().get(i), miningRestrictions.restrictions().get(i));
                }
                for (i = 0; i < enchantmentRestrictions.ids().size(); ++i) {
                    LevelManager.ENCHANTMENT_RESTRICTIONS.put(enchantmentRestrictions.ids().get(i), enchantmentRestrictions.restrictions().get(i));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(StatPacket.PACKET_ID, (payload, context) -> {
            int id = payload.id();
            int level = payload.level();
            context.client().execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)context.player()).getLevelManager();
                levelManager.setSkillLevel(id, level);
                class_437 patt0$temp = context.client().field_1755;
                if (patt0$temp instanceof LevelScreen) {
                    LevelScreen levelScreen = (LevelScreen)patt0$temp;
                    levelScreen.updateLevelButtons();
                }
            });
        });
    }
}

