/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.screen.widget;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.LevelzMain;
import net.levelz.level.LevelManager;
import net.levelz.level.restriction.PlayerRestriction;
import net.levelz.mixin.entity.VehicleEntityAccessor;
import net.levelz.registry.EnchantmentRegistry;
import net.levelz.registry.EnchantmentZ;
import net.levelz.screen.LevelScreen;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8836;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LineWidget {
    private final class_310 client;
    @Nullable
    private final class_2561 text;
    @Nullable
    private final Map<Integer, PlayerRestriction> restrictions;
    private final int code;
    private Map<Integer, class_1799> customStacks;
    private Map<Integer, class_2960> customImages;

    public LineWidget(class_310 client, @Nullable class_2561 text, @Nullable Map<Integer, PlayerRestriction> restrictions, int code) {
        block8: {
            block7: {
                this.client = client;
                this.text = text;
                this.restrictions = restrictions;
                this.code = code;
                if (this.code != 2) break block7;
                this.customStacks = new HashMap<Integer, class_1799>();
                this.customImages = new HashMap<Integer, class_2960>();
                for (Integer id : this.restrictions.keySet()) {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(id.intValue());
                    boolean imageExists = false;
                    try {
                        client.method_1478().getResourceOrThrow(LevelzMain.identifierOf("textures/gui/sprites/entity/" + class_7923.field_41177.method_10221((Object)entityType).method_12832() + ".png"));
                        imageExists = true;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                    if (imageExists) {
                        this.customImages.put(id, LevelzMain.identifierOf("textures/gui/sprites/entity/" + class_7923.field_41177.method_10221((Object)entityType).method_12832() + ".png"));
                        continue;
                    }
                    if (class_1826.method_8019((class_1299)entityType) != null) {
                        this.customStacks.put(id, new class_1799((class_1935)Objects.requireNonNull(class_1826.method_8019((class_1299)entityType))));
                        continue;
                    }
                    class_1297 class_12972 = entityType.method_5883((class_1937)this.client.field_1687);
                    if (class_12972 instanceof class_8836) {
                        class_8836 vehicleEntity = (class_8836)class_12972;
                        this.customStacks.put(id, new class_1799((class_1935)((VehicleEntityAccessor)vehicleEntity).callAsItem()));
                        continue;
                    }
                    this.customImages.put(id, LevelzMain.identifierOf("textures/gui/sprites/entity/default.png"));
                }
                break block8;
            }
            if (this.code != 3) break block8;
            this.customStacks = new HashMap<Integer, class_1799>();
            for (Integer id : this.restrictions.keySet()) {
                EnchantmentZ enchantmentZ = EnchantmentRegistry.getEnchantmentZ(id);
                this.customStacks.put(id, class_1772.method_7808((class_1889)new class_1889(enchantmentZ.getEntry(), enchantmentZ.getLevel())));
            }
        }
    }

    public void render(class_332 drawContext, int x, int y, int mouseX, int mouseY) {
        if (this.text != null) {
            drawContext.method_51439(this.client.field_1772, this.text, x, y + 4, 0x3F3F3F, false);
        } else {
            int separator = 0;
            boolean showTooltip = false;
            for (Map.Entry<Integer, PlayerRestriction> entry : this.restrictions.entrySet()) {
                class_2561 tooltipTitle;
                drawContext.method_25302(LevelScreen.ICON_TEXTURE, x + separator - 1, y - 1, 0, 148, 18, 18);
                if (this.code == 0) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10200(entry.getKey().intValue());
                    tooltipTitle = item.method_7848();
                    drawContext.method_51427(((class_1792)class_7923.field_41178.method_10200(entry.getKey().intValue())).method_7854(), x + separator, y);
                } else if (this.code == 1) {
                    class_2248 block = (class_2248)class_7923.field_41175.method_10200(entry.getKey().intValue());
                    tooltipTitle = block.method_9518();
                    drawContext.method_51427(block.method_8389().method_7854(), x + separator, y);
                } else if (this.code == 2) {
                    class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(entry.getKey().intValue());
                    tooltipTitle = entityType.method_5897();
                    if (this.customStacks.containsKey(entry.getKey())) {
                        drawContext.method_51427(this.customStacks.get(entry.getKey()), x + separator, y);
                    } else {
                        drawContext.method_25302(this.customImages.get(entry.getKey()), x + separator, y, 0, 0, 16, 16);
                    }
                } else {
                    class_1799 stack = this.customStacks.get(entry.getKey());
                    class_6880 enchantment = (class_6880)class_1890.method_57532((class_1799)stack).method_57534().stream().findFirst().get();
                    int level = ((class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385)).method_57536(enchantment);
                    tooltipTitle = class_1887.method_8179((class_6880)enchantment, (int)level);
                    drawContext.method_51427(stack, x + separator, y);
                }
                if (!showTooltip && LevelScreen.isPointWithinBounds(x + separator, y, 16, 16, mouseX, mouseY)) {
                    ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                    tooltip.add(tooltipTitle);
                    for (Map.Entry<Integer, Integer> restriction : entry.getValue().getSkillLevelRestrictions().entrySet()) {
                        tooltip.add(class_2561.method_30163((String)(LevelManager.SKILLS.get(restriction.getKey()).getText().getString() + " " + class_2561.method_43469((String)"text.levelz.gui.short_level", (Object[])new Object[]{restriction.getValue()}).getString())));
                    }
                    drawContext.method_51434(this.client.field_1772, tooltip, mouseX, mouseY);
                    showTooltip = true;
                }
                separator += 18;
            }
        }
    }
}

