/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.util;

import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.levelz.level.PlayerSkill;
import net.levelz.level.Skill;
import net.levelz.level.SkillAttribute;
import net.levelz.level.SkillBonus;
import net.levelz.network.packet.LevelPacket;
import net.levelz.network.packet.PlayerSkillSyncPacket;
import net.levelz.network.packet.RestrictionPacket;
import net.levelz.network.packet.SkillSyncPacket;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class PacketHelper {
    public static void updateLevels(class_3222 serverPlayerEntity) {
        LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
        int overallLevel = levelManager.getOverallLevel();
        int skillPoints = levelManager.getSkillPoints();
        int totalLevelExperience = levelManager.getTotalLevelExperience();
        float levelProgress = levelManager.getLevelProgress();
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new LevelPacket(overallLevel, skillPoints, totalLevelExperience, levelProgress));
    }

    public static void updateSkills(class_3222 serverPlayerEntity) {
        ArrayList<Integer> skillIds = new ArrayList<Integer>();
        ArrayList<String> skillKeys = new ArrayList<String>();
        ArrayList<Integer> skillMaxLevels = new ArrayList<Integer>();
        ArrayList<SkillSyncPacket.SkillAttributesRecord> skillAttributes = new ArrayList<SkillSyncPacket.SkillAttributesRecord>();
        ArrayList<SkillBonus> skillBonuses = new ArrayList<SkillBonus>(LevelManager.BONUSES.values());
        for (Skill skill : LevelManager.SKILLS.values()) {
            skillIds.add(skill.getId());
            skillKeys.add(skill.getKey());
            skillMaxLevels.add(skill.getMaxLevel());
            ArrayList<SkillAttribute> skillAttributeList = new ArrayList<SkillAttribute>(skill.getAttributes());
            skillAttributes.add(new SkillSyncPacket.SkillAttributesRecord(skillAttributeList));
        }
        SkillSyncPacket.SkillBonusesRecord skillBonusesRecord = new SkillSyncPacket.SkillBonusesRecord(skillBonuses);
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new SkillSyncPacket(skillIds, skillKeys, skillMaxLevels, skillAttributes, skillBonusesRecord));
    }

    public static void updatePlayerSkills(class_3222 serverPlayerEntity, @Nullable class_3222 oldPlayerEntity) {
        LevelManager levelManager = ((LevelManagerAccess)serverPlayerEntity).getLevelManager();
        if (oldPlayerEntity != null) {
            LevelManager oldLevelManager = ((LevelManagerAccess)oldPlayerEntity).getLevelManager();
            levelManager.setPlayerSkills(oldLevelManager.getPlayerSkills());
            levelManager.setOverallLevel(oldLevelManager.getOverallLevel());
            levelManager.setTotalLevelExperience(oldLevelManager.getTotalLevelExperience());
            levelManager.setSkillPoints(oldLevelManager.getSkillPoints());
            levelManager.setLevelProgress(oldLevelManager.getLevelProgress());
        }
        ArrayList<Integer> playerSkillIds = new ArrayList<Integer>();
        ArrayList<Integer> playerSkillLevels = new ArrayList<Integer>();
        for (PlayerSkill playerSkill : levelManager.getPlayerSkills().values()) {
            playerSkillIds.add(playerSkill.getId());
            playerSkillLevels.add(playerSkill.getLevel());
        }
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new PlayerSkillSyncPacket(playerSkillIds, playerSkillLevels));
    }

    public static void updateRestrictions(class_3222 serverPlayerEntity) {
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new RestrictionPacket(new RestrictionPacket.RestrictionRecord(LevelManager.BLOCK_RESTRICTIONS.keySet().stream().toList(), LevelManager.BLOCK_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.CRAFTING_RESTRICTIONS.keySet().stream().toList(), LevelManager.CRAFTING_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ENTITY_RESTRICTIONS.keySet().stream().toList(), LevelManager.ENTITY_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ITEM_RESTRICTIONS.keySet().stream().toList(), LevelManager.ITEM_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.MINING_RESTRICTIONS.keySet().stream().toList(), LevelManager.MINING_RESTRICTIONS.values().stream().toList()), new RestrictionPacket.RestrictionRecord(LevelManager.ENCHANTMENT_RESTRICTIONS.keySet().stream().toList(), LevelManager.ENCHANTMENT_RESTRICTIONS.values().stream().toList())));
    }
}

