/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.levelz.access.LevelManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.level.LevelManager;
import net.levelz.level.restriction.PlayerRestriction;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TooltipUtil {
    public static void renderItemTooltip(class_310 client, class_1799 stack, List<class_2561> lines) {
        if (client.field_1724 != null) {
            Map.Entry<Integer, Integer> entry;
            PlayerRestriction playerRestriction;
            Iterator<Map.Entry<Integer, Integer>> playerRestriction2;
            LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
            boolean isCreative = client.field_1724.method_7337();
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                int blockId = class_7923.field_41175.method_10206((Object)blockItem.method_7711());
                if ((isCreative || !levelManager.hasRequiredBlockLevel(blockItem.method_7711())) && LevelManager.BLOCK_RESTRICTIONS.containsKey(blockId)) {
                    playerRestriction2 = LevelManager.BLOCK_RESTRICTIONS.get(blockId);
                    lines.add((class_2561)class_2561.method_43471((String)"restriction.levelz.usable.tooltip"));
                    for (Map.Entry<Integer, Integer> entry2 : ((PlayerRestriction)((Object)playerRestriction2)).getSkillLevelRestrictions().entrySet()) {
                        if (!isCreative && levelManager.getSkillLevel(entry2.getKey()) >= entry2.getValue()) continue;
                        lines.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry2.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry2.getValue()}).method_27692(class_124.field_1061));
                    }
                }
                if ((isCreative || !levelManager.hasRequiredMiningLevel(blockItem.method_7711())) && LevelManager.MINING_RESTRICTIONS.containsKey(blockId)) {
                    playerRestriction2 = LevelManager.MINING_RESTRICTIONS.get(blockId);
                    lines.add((class_2561)class_2561.method_43471((String)"restriction.levelz.mineable.tooltip"));
                    for (Map.Entry<Integer, Integer> entry2 : ((PlayerRestriction)((Object)playerRestriction2)).getSkillLevelRestrictions().entrySet()) {
                        if (!isCreative && levelManager.getSkillLevel(entry2.getKey()) >= entry2.getValue()) continue;
                        lines.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry2.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry2.getValue()}).method_27692(class_124.field_1061));
                    }
                }
            }
            int itemId = class_7923.field_41178.method_10206((Object)stack.method_7909());
            if ((isCreative || !levelManager.hasRequiredItemLevel(stack.method_7909())) && LevelManager.ITEM_RESTRICTIONS.containsKey(itemId)) {
                playerRestriction = LevelManager.ITEM_RESTRICTIONS.get(itemId);
                lines.add((class_2561)class_2561.method_43471((String)"restriction.levelz.usable.tooltip"));
                playerRestriction2 = playerRestriction.getSkillLevelRestrictions().entrySet().iterator();
                while (playerRestriction2.hasNext()) {
                    entry = (Map.Entry<Integer, Integer>)playerRestriction2.next();
                    if (!isCreative && levelManager.getSkillLevel((Integer)entry.getKey()) >= entry.getValue()) continue;
                    lines.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry.getValue()}).method_27692(class_124.field_1061));
                }
            }
            if ((isCreative || !levelManager.hasRequiredCraftingLevel(stack.method_7909())) && LevelManager.CRAFTING_RESTRICTIONS.containsKey(itemId)) {
                playerRestriction = LevelManager.CRAFTING_RESTRICTIONS.get(itemId);
                lines.add((class_2561)class_2561.method_43471((String)"restriction.levelz.craftable.tooltip"));
                playerRestriction2 = playerRestriction.getSkillLevelRestrictions().entrySet().iterator();
                while (playerRestriction2.hasNext()) {
                    entry = playerRestriction2.next();
                    if (!isCreative && levelManager.getSkillLevel(entry.getKey()) >= entry.getValue()) continue;
                    lines.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry.getValue()}).method_27692(class_124.field_1061));
                }
            }
            if ((playerRestriction2 = stack.method_7909()) instanceof class_1826) {
                int entityId;
                class_1826 spawnEggItem = (class_1826)playerRestriction2;
                if ((isCreative || !levelManager.hasRequiredEntityLevel(spawnEggItem.method_8015(stack))) && LevelManager.ENTITY_RESTRICTIONS.containsKey(entityId = class_7923.field_41177.method_10206((Object)spawnEggItem.method_8015(stack)))) {
                    PlayerRestriction playerRestriction3 = LevelManager.ENTITY_RESTRICTIONS.get(entityId);
                    lines.add((class_2561)class_2561.method_43471((String)"restriction.levelz.usable.tooltip"));
                    for (Map.Entry<Integer, Integer> entry3 : playerRestriction3.getSkillLevelRestrictions().entrySet()) {
                        if (!isCreative && levelManager.getSkillLevel(entry3.getKey()) >= entry3.getValue()) continue;
                        lines.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry3.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry3.getValue()}).method_27692(class_124.field_1061));
                    }
                }
            }
        }
    }

    public static void renderTooltip(class_310 client, class_332 context) {
        if (client.field_1765 != null && ConfigInit.CONFIG.showLockedBlockInfo) {
            class_239 hitResult = client.field_1765;
            if (hitResult.method_17783() == class_239.class_240.field_1331) {
                class_1299 entityType;
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                if (!levelManager.hasRequiredEntityLevel(entityType = ((class_3966)hitResult).method_17782().method_5864())) {
                    ArrayList<class_2561> textList = new ArrayList<class_2561>();
                    textList.add(class_2561.method_30163((String)entityType.method_5897().getString()));
                    for (Map.Entry<Integer, Integer> entry : levelManager.getRequiredEntityLevel(entityType).entrySet()) {
                        class_124 formatting = levelManager.getSkillLevel(entry.getKey()) < entry.getValue() ? class_124.field_1061 : class_124.field_1060;
                        textList.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry.getValue()}).method_27692(formatting));
                    }
                    TooltipUtil.renderTooltip(client, context, textList, null, context.method_51421() / 2 + ConfigInit.CONFIG.lockedBlockInfoPosX, ConfigInit.CONFIG.lockedBlockInfoPosY);
                }
            } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
                class_124 formatting;
                class_2248 block = client.field_1687.method_8320(((class_3965)hitResult).method_17777()).method_26204();
                LevelManager levelManager = ((LevelManagerAccess)client.field_1724).getLevelManager();
                ArrayList<class_2561> textList = new ArrayList<class_2561>();
                if (!levelManager.hasRequiredMiningLevel(block)) {
                    textList.add(class_2561.method_30163((String)block.method_9518().getString()));
                    for (Map.Entry<Integer, Integer> entry : levelManager.getRequiredMiningLevel(block).entrySet()) {
                        formatting = levelManager.getSkillLevel(entry.getKey()) < entry.getValue() ? class_124.field_1061 : class_124.field_1060;
                        textList.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry.getValue()}).method_27692(formatting));
                    }
                }
                if (!levelManager.hasRequiredBlockLevel(block)) {
                    if (textList.isEmpty()) {
                        textList.add(class_2561.method_30163((String)block.method_9518().getString()));
                    }
                    textList.add((class_2561)class_2561.method_43471((String)"restriction.levelz.block_usage"));
                    for (Map.Entry<Integer, Integer> entry : levelManager.getRequiredBlockLevel(block).entrySet()) {
                        formatting = levelManager.getSkillLevel(entry.getKey()) < entry.getValue() ? class_124.field_1061 : class_124.field_1060;
                        textList.add((class_2561)class_2561.method_43469((String)("restriction.levelz." + LevelManager.SKILLS.get(entry.getKey()).getKey() + ".tooltip"), (Object[])new Object[]{entry.getValue()}).method_27692(formatting));
                    }
                }
                if (!textList.isEmpty()) {
                    TooltipUtil.renderTooltip(client, context, textList, class_7923.field_41175.method_10221((Object)block), context.method_51421() / 2 + ConfigInit.CONFIG.lockedBlockInfoPosX, ConfigInit.CONFIG.lockedBlockInfoPosY);
                }
            }
        }
    }

    private static void renderTooltip(class_310 client, class_332 context, List<class_2561> textList, @Nullable class_2960 identifier, int x, int y) {
        int maxTextWidth = 0;
        for (int i = 0; i < textList.size(); ++i) {
            if (client.field_1772.method_27525((class_5348)textList.get(i)) <= maxTextWidth) continue;
            maxTextWidth = client.field_1772.method_27525((class_5348)textList.get(i));
            if (i != 0 || identifier == null) continue;
            maxTextWidth += 22;
        }
        context.method_51448().method_22903();
        int colorStart = -1088874215;
        int colorTwo = -1082195456;
        int colorThree = -1086849024;
        TooltipUtil.render(context, x - (maxTextWidth += 5) / 2 - 3, y + 4, maxTextWidth, textList.size() * 10 + 11, 400, colorStart, colorTwo, colorThree);
        context.method_51448().method_22904(0.0, 0.0, 400.0);
        int i = 9;
        for (class_2561 text : textList) {
            if (i == 9) {
                context.method_51439(client.field_1772, text, x - maxTextWidth / 2 + (identifier != null ? 20 : 0), y + i, 0xFFFFFF, false);
            } else {
                context.method_51439(client.field_1772, text, x - maxTextWidth / 2, y + i + 8, 0xFFFFFF, false);
            }
            i += 10;
        }
        if (identifier != null) {
            context.method_51427(((class_1792)class_7923.field_41178.method_10223(identifier)).method_7854(), x - maxTextWidth / 2, y + 5);
        }
        context.method_51448().method_22909();
    }

    public static void render(class_332 context, int x, int y, int width, int height, int z, int background, int borderColorStart, int borderColorEnd) {
        int i = x - 3;
        int j = y - 3;
        int k = width + 3 + 3;
        int l = height + 3 + 3;
        TooltipUtil.renderHorizontalLine(context, i, j - 1, k, z, background);
        TooltipUtil.renderHorizontalLine(context, i, j + l, k, z, background);
        TooltipUtil.renderRectangle(context, i, j, k, l, z, background);
        TooltipUtil.renderVerticalLine(context, i - 1, j, l, z, background);
        TooltipUtil.renderVerticalLine(context, i + k, j, l, z, background);
        TooltipUtil.renderBorder(context, i, j + 1, k, l, z, borderColorStart, borderColorEnd);
        TooltipUtil.renderHorizontalLine(context, z, x + 3, y + 19, x + 3 + (width -= 6) / 2, y + 20, 8323584, -1082195456);
        TooltipUtil.renderHorizontalLine(context, z, x + 3 + width / 2, y + 19, x + 3 + width, y + 20, -1082195456, 8323584);
    }

    private static void renderBorder(class_332 context, int x, int y, int width, int height, int z, int startColor, int endColor) {
        TooltipUtil.renderVerticalLine(context, x, y, height - 2, z, startColor, endColor);
        TooltipUtil.renderVerticalLine(context, x + width - 1, y, height - 2, z, startColor, endColor);
        TooltipUtil.renderHorizontalLine(context, x, y - 1, width, z, startColor);
        TooltipUtil.renderHorizontalLine(context, x, y - 1 + height - 1, width, z, endColor);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int color) {
        context.method_51737(x, y, x + 1, y + height, z, color);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int startColor, int endColor) {
        context.method_33284(x, y, x + 1, y + height, z, startColor, endColor);
    }

    private static void renderHorizontalLine(class_332 context, int x, int y, int width, int z, int color) {
        context.method_51737(x, y, x + width, y + 1, z, color);
    }

    private static void renderRectangle(class_332 context, int x, int y, int width, int height, int z, int color) {
        context.method_51737(x, y, x + width, y + height, z, color);
    }

    public static void renderHorizontalLine(class_332 context, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, (float)right, (float)top, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        vertexConsumer.method_22918(matrix4f, (float)left, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.method_22918(matrix4f, (float)left, (float)bottom, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.method_22918(matrix4f, (float)right, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        context.method_51452();
        RenderSystem.disableBlend();
    }
}

