/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.distance;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;
import net.treset.adaptiveview.AdaptiveViewMod;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.config.Rule;
import net.treset.adaptiveview.config.RuleTarget;
import net.treset.adaptiveview.config.ServerState;
import net.treset.adaptiveview.tools.BroadcastLevel;
import net.treset.adaptiveview.tools.MathTools;
import net.treset.adaptiveview.tools.NotificationState;
import net.treset.adaptiveview.tools.TextTools;

public class ViewDistanceHandler {
    private final Config config;

    public ViewDistanceHandler(Config config) {
        this.config = config;
    }

    public int updateViewDistance(ServerState state) {
        int targetSimDistance;
        int targetViewDistance;
        ArrayList<Rule> viewDistanceRules = new ArrayList<Rule>();
        ArrayList<Integer> viewDistanceIndexes = new ArrayList<Integer>();
        ArrayList<Rule> simDistanceRules = new ArrayList<Rule>();
        ArrayList<Integer> simDistanceIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.config.getRules().size(); ++i) {
            Rule rule = this.config.getRules().get(i);
            if (!rule.applies(state)) continue;
            if (rule.getTarget() == RuleTarget.SIMULATION) {
                simDistanceRules.add(rule);
                simDistanceIndexes.add(i + 1);
                continue;
            }
            viewDistanceRules.add(rule);
            viewDistanceIndexes.add(i + 1);
        }
        int maxViewDistance = Integer.MAX_VALUE;
        int minViewDistance = 0;
        int viewStep = 0;
        int updateRate = Integer.MAX_VALUE;
        for (Rule rule : viewDistanceRules) {
            if (rule.getMaxDistance() != null && rule.getMaxDistance() < maxViewDistance) {
                maxViewDistance = rule.getMaxDistance();
            }
            if (rule.getMinDistance() != null && rule.getMinDistance() > minViewDistance) {
                minViewDistance = rule.getMinDistance();
            }
            if (rule.getUpdateRate() != null && rule.getUpdateRate() < updateRate) {
                updateRate = rule.getUpdateRate();
            }
            if (rule.getStep() == null) continue;
            rule.incrementCounter();
            if (rule.getStep() < 0 && rule.getStep() < viewStep) {
                viewStep = rule.getStep();
                continue;
            }
            if (rule.getStep() <= 0 || rule.getStep() <= viewStep) continue;
            viewStep = rule.getStep();
        }
        int maxSimDistance = Integer.MAX_VALUE;
        int minSimDistance = 0;
        int simStep = 0;
        for (Rule rule : simDistanceRules) {
            if (rule.getMaxDistance() != null && rule.getMaxDistance() < maxViewDistance) {
                maxSimDistance = rule.getMaxDistance();
            }
            if (rule.getMinDistance() != null && rule.getMinDistance() > minViewDistance) {
                minSimDistance = rule.getMinDistance();
            }
            if (rule.getUpdateRate() != null && rule.getUpdateRate() < updateRate) {
                updateRate = rule.getUpdateRate();
            }
            if (rule.getStep() == null) continue;
            rule.incrementCounter();
            if (rule.getStep() < 0 && rule.getStep() < viewStep) {
                simStep = rule.getStep();
                continue;
            }
            if (rule.getStep() <= 0 || rule.getStep() <= viewStep) continue;
            simStep = rule.getStep();
        }
        if (maxViewDistance == Integer.MAX_VALUE) {
            maxViewDistance = this.config.getMaxViewDistance();
        }
        if (minViewDistance == 0) {
            minViewDistance = this.config.getMinViewDistance();
        }
        if (maxViewDistance < minViewDistance) {
            maxViewDistance = minViewDistance;
        }
        if ((targetViewDistance = MathTools.clamp(state.getCurrentViewDistance() + viewStep, minViewDistance, maxViewDistance)) != state.getCurrentViewDistance() && !this.config.isViewLocked()) {
            TextTools.broadcastIf(p -> ViewDistanceHandler.shouldBroadcastChange(p, this.config), "Changed View Distance from %d to %d because of %s.", state.getCurrentViewDistance(), targetViewDistance, this.getRuleCauseString(viewDistanceIndexes));
            this.setViewDistance(targetViewDistance);
        }
        if (maxSimDistance == Integer.MAX_VALUE) {
            maxSimDistance = this.config.getMaxSimDistance();
        }
        if (minSimDistance == 0) {
            minSimDistance = this.config.getMinSimDistance();
        }
        if (maxSimDistance < minSimDistance) {
            maxSimDistance = minSimDistance;
        }
        if ((targetSimDistance = MathTools.clamp(state.getCurrentSimDistance() + simStep, minSimDistance, maxSimDistance)) != state.getCurrentSimDistance() && !this.config.isSimLocked()) {
            TextTools.broadcastIf(p -> ViewDistanceHandler.shouldBroadcastChange(p, this.config), "Changed Simulation Distance from %d to %d because of %s.", state.getCurrentSimDistance(), targetSimDistance, this.getRuleCauseString(simDistanceIndexes));
            this.setSimDistance(targetSimDistance);
        }
        if (updateRate == Integer.MAX_VALUE) {
            updateRate = this.config.getUpdateRate();
        }
        return updateRate;
    }

    private String getRuleCauseString(List<Integer> activeIndexes) {
        if (activeIndexes.isEmpty()) {
            return "no Rules";
        }
        if (activeIndexes.size() == 1) {
            String ruleName = this.config.getRules().get(activeIndexes.get(0) - 1).getName();
            if (ruleName == null) {
                ruleName = activeIndexes.get(0).toString();
            }
            return "Rule " + ruleName;
        }
        StringBuilder sb = new StringBuilder("Rules ");
        String ruleName1 = this.config.getRules().get(activeIndexes.get(0) - 1).getName();
        if (ruleName1 == null) {
            ruleName1 = activeIndexes.get(0).toString();
        }
        sb.append(ruleName1);
        for (int i = 1; i < activeIndexes.size() - 1; ++i) {
            String ruleName = this.config.getRules().get(activeIndexes.get(i) - 1).getName();
            if (ruleName == null) {
                ruleName = activeIndexes.get(i).toString();
            }
            sb.append(", ").append(ruleName);
        }
        String ruleNameN = this.config.getRules().get(activeIndexes.get(activeIndexes.size() - 1) - 1).getName();
        if (ruleNameN == null) {
            ruleNameN = activeIndexes.get(activeIndexes.size() - 1).toString();
        }
        sb.append(" and ").append(ruleNameN);
        return sb.toString();
    }

    public void setViewDistance(int chunks) {
        AdaptiveViewMod.getServer().method_3760().method_14608(chunks);
    }

    public void setSimDistance(int chunks) {
        AdaptiveViewMod.getServer().method_3760().method_38650(chunks);
    }

    public static int getViewDistance() {
        return AdaptiveViewMod.getServer().method_3760().method_14568();
    }

    public static int getSimDistance() {
        return AdaptiveViewMod.getServer().method_3760().method_38651();
    }

    public static boolean shouldBroadcastChange(class_3222 player, Config config) {
        NotificationState state = NotificationState.getFromPlayer(player, config.getBroadcastChanges());
        if (state == NotificationState.ADDED) {
            return true;
        }
        if (state == NotificationState.REMOVED) {
            return false;
        }
        return switch (config.getBroadcastChangesDefault()) {
            default -> throw new IncompatibleClassChangeError();
            case BroadcastLevel.ALL -> true;
            case BroadcastLevel.NONE -> false;
            case BroadcastLevel.OPS -> AdaptiveViewMod.getServer().method_3760().method_14569(player.method_7334());
        };
    }
}

