/*
 * Decompiled with CFR 0.152.
 */
package net.treset.adaptiveview.unlocking;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3222;
import net.treset.adaptiveview.AdaptiveViewMod;
import net.treset.adaptiveview.config.Config;
import net.treset.adaptiveview.distance.ViewDistanceHandler;
import net.treset.adaptiveview.tools.BroadcastLevel;
import net.treset.adaptiveview.tools.NotificationState;
import net.treset.adaptiveview.unlocking.LockTarget;
import net.treset.adaptiveview.unlocking.Locker;

public class LockManager {
    private final Config config;
    private final ViewDistanceHandler viewDistanceHandler;
    private final List<Locker> lockers = new ArrayList<Locker>();
    private int viewLockedManually = 0;
    private int simLockedManually = 0;
    private Locker currentViewLocker = null;
    private Locker currentSimLocker = null;
    private final List<Locker> toRemove = new ArrayList<Locker>();

    public LockManager(Config config, ViewDistanceHandler viewDistanceHandler) {
        this.config = config;
        this.viewDistanceHandler = viewDistanceHandler;
    }

    public void lockManually(Integer chunks, LockTarget target) {
        if (target == LockTarget.VIEW || target == LockTarget.ALL) {
            if (chunks == null || chunks == Integer.MAX_VALUE) {
                this.viewLockedManually = 0;
                this.lockView(Integer.MAX_VALUE);
            } else {
                this.viewLockedManually = chunks;
                this.lockView(chunks);
            }
        }
        if (target == LockTarget.SIM || target == LockTarget.ALL) {
            if (chunks == null || chunks == Integer.MAX_VALUE) {
                this.simLockedManually = 0;
                this.lockSim(Integer.MAX_VALUE);
            } else {
                this.simLockedManually = chunks;
                this.lockSim(chunks);
            }
        }
        this.updateLocker();
    }

    public Integer getLockedManually(LockTarget target) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case LockTarget.VIEW -> {
                if (this.viewLockedManually != 0) {
                    yield this.viewLockedManually;
                }
                yield null;
            }
            case LockTarget.SIM -> {
                if (this.simLockedManually != 0) {
                    yield this.simLockedManually;
                }
                yield null;
            }
            case LockTarget.ALL -> this.viewLockedManually != 0 && this.simLockedManually != 0 ? Integer.valueOf(Math.min(this.viewLockedManually, this.simLockedManually)) : (this.viewLockedManually != 0 ? Integer.valueOf(this.viewLockedManually) : (this.simLockedManually != 0 ? Integer.valueOf(this.simLockedManually) : null));
        };
    }

    public Locker getCurrentLocker(LockTarget target) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case LockTarget.VIEW -> this.currentViewLocker;
            case LockTarget.SIM -> this.currentSimLocker;
            case LockTarget.ALL -> {
                if (this.currentViewLocker != null && this.currentSimLocker != null) {
                    if (this.currentViewLocker.getDistance() < this.currentSimLocker.getDistance()) {
                        yield this.currentViewLocker;
                    }
                    yield this.currentSimLocker;
                }
                yield this.currentViewLocker != null ? this.currentViewLocker : (this.currentSimLocker != null ? this.currentSimLocker : null);
            }
        };
    }

    public int getNumLockers(LockTarget target) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case LockTarget.VIEW -> (int)this.lockers.stream().filter(e -> e.getTarget() == LockTarget.VIEW || e.getTarget() == LockTarget.ALL).count();
            case LockTarget.SIM -> (int)this.lockers.stream().filter(e -> e.getTarget() == LockTarget.SIM || e.getTarget() == LockTarget.ALL).count();
            case LockTarget.ALL -> this.lockers.size();
        };
    }

    public void addLocker(Locker unlocker) {
        this.lockers.add(unlocker);
        this.updateLocker();
    }

    public void clearLockers(LockTarget target) {
        switch (target) {
            case VIEW: {
                for (Locker e : this.lockers) {
                    if (e.getTarget() == LockTarget.VIEW) {
                        this.finishLocker(e);
                        continue;
                    }
                    if (e.getTarget() != LockTarget.ALL) continue;
                    e.setTarget(LockTarget.SIM);
                }
                break;
            }
            case SIM: {
                for (Locker e : this.lockers) {
                    if (e.getTarget() == LockTarget.SIM) {
                        this.finishLocker(e);
                        continue;
                    }
                    if (e.getTarget() != LockTarget.ALL) continue;
                    e.setTarget(LockTarget.VIEW);
                }
                break;
            }
            case ALL: {
                for (Locker e : this.lockers) {
                    this.finishLocker(e);
                }
                break;
            }
        }
        this.updateLocker();
    }

    public void finishLocker(Locker unlocker) {
        this.toRemove.add(unlocker);
    }

    public void updateLocker() {
        if (this.getLockedManually(LockTarget.ALL) != null) {
            return;
        }
        ArrayList<Locker> viewLockers = new ArrayList<Locker>();
        ArrayList<Locker> simLockers = new ArrayList<Locker>();
        for (Locker e : this.lockers) {
            switch (e.getTarget()) {
                case ALL: {
                    viewLockers.add(e);
                    simLockers.add(e);
                    break;
                }
                case VIEW: {
                    viewLockers.add(e);
                    break;
                }
                case SIM: {
                    simLockers.add(e);
                }
            }
        }
        if (this.getLockedManually(LockTarget.VIEW) == null) {
            int viewDistance = Integer.MAX_VALUE;
            Locker viewLocker = null;
            for (Locker e : viewLockers) {
                if (e.getDistance() >= viewDistance) continue;
                viewDistance = e.getDistance();
                viewLocker = e;
            }
            this.currentViewLocker = viewLocker;
            this.lockView(viewDistance);
        }
        if (this.getLockedManually(LockTarget.SIM) == null) {
            int simDistance = Integer.MAX_VALUE;
            Locker simLocker = null;
            for (Locker e : simLockers) {
                if (e.getDistance() >= simDistance) continue;
                simDistance = e.getDistance();
                simLocker = e;
            }
            this.currentSimLocker = simLocker;
            this.lockSim(simDistance);
        }
    }

    public void lockView(int chunks) {
        if (chunks == Integer.MAX_VALUE) {
            this.currentViewLocker = null;
            this.config.setViewLocked(false);
        } else if (ViewDistanceHandler.getViewDistance() != chunks) {
            this.viewDistanceHandler.setViewDistance(chunks);
            this.config.setViewLocked(true);
        }
    }

    public void lockSim(int chunks) {
        if (chunks == Integer.MAX_VALUE) {
            this.currentSimLocker = null;
            this.config.setViewLocked(false);
        } else if (ViewDistanceHandler.getSimDistance() != chunks) {
            this.viewDistanceHandler.setSimDistance(chunks);
            this.config.setSimLocked(true);
        }
    }

    public void onTick() {
        for (Locker e : this.lockers) {
            e.onTick();
        }
        this.lockers.removeAll(this.toRemove);
        this.updateLocker();
    }

    public Config getConfig() {
        return this.config;
    }

    public static boolean shouldBroadcastLock(class_3222 player, Config config) {
        NotificationState state = NotificationState.getFromPlayer(player, config.getBroadcastLock());
        if (state == NotificationState.ADDED) {
            return true;
        }
        if (state == NotificationState.REMOVED) {
            return false;
        }
        return switch (config.getBroadcastLockDefault()) {
            default -> throw new IncompatibleClassChangeError();
            case BroadcastLevel.ALL -> true;
            case BroadcastLevel.NONE -> false;
            case BroadcastLevel.OPS -> AdaptiveViewMod.getServer().method_3760().method_14569(player.method_7334());
        };
    }
}

