/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.coordfinder.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.coordfinder.CoordFinder;
import de.maxhenkel.coordfinder.Location;
import de.maxhenkel.coordfinder.config.PlaceConfig;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Command(value={"coords"})
public class CoordCommands {
    @RequiresPermission(value="coordfinder.playerlocation")
    @Command(value={"player"})
    public void playerCoords(CommandContext<class_2168> context, @Name(value="player") class_3222 player) {
        if (CoordFinder.HIDDEN_PLAYERS.getOrDefault(player.method_5667(), false).booleanValue()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player ").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" is hidden.")), false);
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player ").method_10852(player.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" is at ")).method_10852(CoordCommands.fromLocation(Location.fromPlayer(player))).method_27693("."), false);
    }

    @RequiresPermission(value="coordfinder.modifyplaces")
    @Command(value={"setplace"})
    public void setPlace(CommandContext<class_2168> context, @Name(value="name") String placeName, @Name(value="location") Optional<class_243> location, @Name(value="dimension") Optional<class_3218> dimension) {
        CoordCommands.setPlace(context, placeName, dimension.orElseGet(() -> ((class_2168)context.getSource()).method_9225()), location.orElseGet(() -> ((class_2168)context.getSource()).method_9222()));
    }

    @RequiresPermission(value="coordfinder.modifyplaces")
    @Command(value={"removeplace"})
    public void removePlace(CommandContext<class_2168> context, @Name(value="name") String placeName) {
        if (!PlaceConfig.isValidPlaceName(placeName)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Invalid place name ").method_10852((class_2561)class_2561.method_43470((String)placeName).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".")), false);
            return;
        }
        CoordFinder.PLACE_CONFIG.removePlace(placeName);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully removed ").method_10852((class_2561)class_2561.method_43470((String)placeName).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".")), false);
    }

    @RequiresPermission(value="coordfinder.getplaces")
    @Command(value={"place"})
    public void place(CommandContext<class_2168> context, @Name(value="name") String placeName) {
        Location place = CoordFinder.PLACE_CONFIG.getPlace(placeName);
        if (place == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Place with name ").method_10852((class_2561)class_2561.method_43470((String)placeName).method_27692(class_124.field_1060)).method_27693(" not found."), false);
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Place ").method_10852((class_2561)class_2561.method_43470((String)placeName).method_27692(class_124.field_1060)).method_27693(" is at ").method_10852(CoordCommands.fromLocation(place)).method_27693("."), false);
    }

    @RequiresPermission(value="coordfinder.getplaces")
    @Command(value={"listplaces"})
    public void listPlaces(CommandContext<class_2168> context) {
        Set<Map.Entry<String, Location>> entries = CoordFinder.PLACE_CONFIG.getPlaces().entrySet();
        for (Map.Entry<String, Location> entry : entries) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Place ").method_10852((class_2561)class_2561.method_43470((String)((String)entry.getKey())).method_27692(class_124.field_1060)).method_27693(" is located at ").method_10852(CoordCommands.fromLocation((Location)entry.getValue())), false);
        }
        if (entries.size() <= 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"There are no places"), false);
        }
    }

    @RequiresPermission(value="coordfinder.hide")
    @Command(value={"hide"})
    public void hide(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        CoordFinder.HIDDEN_PLAYERS.put(player.method_5667(), true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Coordinates successfully hidden. You will stay hidden until the next server restart."), false);
    }

    @RequiresPermission(value="coordfinder.hide")
    @Command(value={"unhide"})
    public void unhide(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        CoordFinder.HIDDEN_PLAYERS.remove(player.method_5667());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Coordinates successfully unhidden."), false);
    }

    public static class_2561 fromLocation(Location location) {
        return class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{location.position().method_10263(), location.position().method_10264(), location.position().method_10260()}).method_27693(" in ").method_10852((class_2561)class_2561.method_43470((String)location.dimension().toString())).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/execute in %s run tp @s %s %s %s".formatted(location.dimension(), location.position().method_10263(), location.position().method_10264(), location.position().method_10260()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.coordinates.tooltip"))))).method_27692(class_124.field_1060);
    }

    private static void setPlace(CommandContext<class_2168> context, String placeName, class_3218 dimension, class_243 location) {
        if (!PlaceConfig.isValidPlaceName(placeName)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Invalid place name. Valid characters are ").method_10852((class_2561)class_2561.method_43470((String)"A-Z").method_27692(class_124.field_1060)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)"a-z").method_27692(class_124.field_1060)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1060)).method_27693(" and ").method_10852((class_2561)class_2561.method_43470((String)"_").method_27692(class_124.field_1060)).method_27693("."), false);
            return;
        }
        Location loc = new Location(dimension.method_27983().method_29177(), new class_2338((int)location.field_1352, (int)location.field_1351, (int)location.field_1350));
        CoordFinder.PLACE_CONFIG.setPlace(placeName, loc);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully set the location of ").method_10852((class_2561)class_2561.method_43470((String)placeName).method_27692(class_124.field_1060)).method_27693(" to ").method_10852(CoordCommands.fromLocation(loc)).method_27693("."), false);
    }
}

