/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class LanternBlockStateGenerator
extends BlockStateGenerator {
    public LanternBlockStateGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addStates(material);
        }
    }

    public void addStates(LanternMaterial material) {
        this.addState(material, null);
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.addState(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainState(material);
        }
    }

    public void addState(LanternMaterial material, LanternColor color) {
        this.blockState(material.getLanternBlock(color)).variantsForAllExcept((state, variant) -> variant.model(LanternBlockStateGenerator.getModelLocation(material, color, (Boolean)state.get((class_2769)class_2741.field_16561), (Boolean)state.get((class_2769)LanternBlock.ON), (Boolean)state.get((class_2769)LanternBlock.REDSTONE))), new class_2769[]{class_2741.field_12508});
    }

    public void addChainState(LanternMaterial material) {
        this.blockState((class_2248)material.getChainBlock()).variantsForAllExcept((state, variant) -> {
            class_2350.class_2351 axis = (class_2350.class_2351)state.get((class_2769)class_2741.field_12496);
            variant.model(LanternBlockStateGenerator.getChainModelLocation(material), axis == class_2350.class_2351.field_11048 || axis == class_2350.class_2351.field_11051 ? 90 : 0, axis == class_2350.class_2351.field_11048 ? 90 : 0, false);
        }, new class_2769[]{class_2741.field_12508});
    }

    public static class_2960 getModelLocation(LanternMaterial material, LanternColor color, boolean hanging, boolean on, boolean redstone) {
        boolean lit;
        boolean bl = lit = on != redstone;
        return color == null ? (hanging ? (lit ? class_2960.method_60655((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_hanging_lantern")) : class_2960.method_60655((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_hanging_lantern_off"))) : (lit ? class_2960.method_60655((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_lantern")) : class_2960.method_60655((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_lantern_off")))) : (hanging ? (lit ? class_2960.method_60655((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern")) : class_2960.method_60655((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern_off"))) : (lit ? class_2960.method_60655((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern")) : class_2960.method_60655((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern_off"))));
    }

    public static class_2960 getChainModelLocation(LanternMaterial material) {
        return class_2960.method_60655((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_chain"));
    }
}

