/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.components;

import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.Component;

public class RehydrationComponent
implements Component {
    private final class_1657 provider;
    private int waterCaptured = 0;
    private static final String WATER_CAPTURED_KEY = "water_captured";

    public RehydrationComponent(class_1657 provider) {
        this.provider = provider;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10573(WATER_CAPTURED_KEY, 3)) {
            this.waterCaptured = tag.method_10550(WATER_CAPTURED_KEY);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.waterCaptured > 0) {
            tag.method_10569(WATER_CAPTURED_KEY, this.waterCaptured);
        }
    }

    public void tickRehydration(double rehydrationEfficiency, int wetChange) {
        if (rehydrationEfficiency > 0.0) {
            if (wetChange < 0 && this.provider.method_59922().method_43056()) {
                int rehydrationCapacity = ServerThirstPlugin.getActivePlugin().getRehydrationThreshold();
                this.waterCaptured = Math.min(this.waterCaptured + 1, rehydrationCapacity);
            }
            this.tickRehydrate(rehydrationEfficiency);
        } else {
            this.resetRehydration();
        }
    }

    private void tickRehydrate(double rehydrationEfficiency) {
        class_1937 class_19372;
        int rehydrationCapacity = ServerThirstPlugin.getActivePlugin().getRehydrationThreshold();
        if (this.waterCaptured >= rehydrationCapacity && (class_19372 = this.provider.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            ServerThirstPlugin plugin = ServerThirstPlugin.getActivePlugin();
            plugin.rehydrateFromEnchantment(this.provider, this.waterCaptured, rehydrationEfficiency);
            this.playRehydrationEffects(serverWorld);
            this.resetRehydration();
        }
    }

    private void resetRehydration() {
        this.waterCaptured = 0;
    }

    private void playRehydrationEffects(class_3218 serverWorld) {
        class_243 pos = this.provider.method_19538();
        if (!this.provider.method_5701() && !this.provider.method_5715()) {
            serverWorld.method_45447(null, this.provider.method_24515(), SSoundEvents.REHYDRATE, this.provider.method_5634());
        }
        if (!this.provider.method_5767()) {
            float height = this.provider.method_17682();
            float width = this.provider.method_17681();
            serverWorld.method_14199((class_2394)class_2398.field_11241, pos.field_1352, pos.field_1351, pos.field_1350, 50, (double)width, (double)height, (double)width, (double)0.001f);
        }
    }
}

