/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.item.component;

import com.github.thedeathlycow.scorchful.config.ThirstConfig;
import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_6862;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public enum DrinkLevelComponent implements class_3542
{
    PARCHING("parching", SItemTags.IS_PARCHING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.parching").method_10862(WaterSkinItem.PARCHING_STYLE), ThirstConfig::getWaterFromParchingFood),
    REFRESHING("refreshing", SItemTags.IS_REFRESHING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.refreshing").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromRefreshingFood),
    SUSTAINING("sustaining", SItemTags.IS_SUSTAINING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.sustaining").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromSustainingFood),
    HYDRATING("hydrating", SItemTags.IS_HYDRATING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.hydrating").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromHydratingFood);

    public static final Codec<DrinkLevelComponent> CODEC;
    public static final IntFunction<DrinkLevelComponent> ID_TO_VALUE;
    public static final class_9139<ByteBuf, DrinkLevelComponent> PACKET_CODEC;
    private final String name;
    private final class_6862<class_1792> tag;
    private final class_2561 tooltipText;
    private final ToIntFunction<ThirstConfig> waterProvider;

    private DrinkLevelComponent(String name, class_6862<class_1792> tag, class_2561 tooltipText, ToIntFunction<ThirstConfig> waterProvider) {
        this.name = name;
        this.tag = tag;
        this.tooltipText = tooltipText;
        this.waterProvider = waterProvider;
    }

    public static void applyToNewStack(class_1799 stack) {
        DrinkLevelComponent level = DrinkLevelComponent.byTag(stack);
        if (level != null) {
            stack.method_57379(SDataComponentTypes.DRINK_LEVEL, (Object)level);
        }
    }

    @Nullable
    private static DrinkLevelComponent byTag(class_1799 stack) {
        for (DrinkLevelComponent level : DrinkLevelComponent.values()) {
            if (!stack.method_31573(level.tag)) continue;
            return level;
        }
        return null;
    }

    public int getDrinkingWater(ThirstConfig config) {
        return this.waterProvider.applyAsInt(config);
    }

    public class_2561 getTooltipText() {
        return this.tooltipText;
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(DrinkLevelComponent::values);
        ID_TO_VALUE = class_7995.method_47914(Enum::ordinal, (Object[])DrinkLevelComponent.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        PACKET_CODEC = class_9135.method_56375(ID_TO_VALUE, Enum::ordinal);
    }
}

