/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Arrays;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerInteractable;
import net.mehvahdjukaar.supplementaries.common.block.IWaxable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class BlackboardBlockTile
extends class_2586
implements IOwnerProtected,
IOnePlayerInteractable,
IScreenProvider,
IWaxable,
IExtraModelDataProvider {
    public static final ModelDataKey<BlackboardData> BLACKBOARD_KEY = ModBlockProperties.BLACKBOARD;
    private UUID owner = null;
    @Nullable
    private UUID playerWhoMayEdit = null;
    private boolean waxed = false;
    private byte[][] pixels = new byte[16][16];
    private BlackboardData textureKey = null;

    public BlackboardBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BLACKBOARD_TILE.get(), pos, state);
        this.clearPixels();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BLACKBOARD_KEY, (Object)this.getTextureKey());
    }

    public BlackboardData getTextureKey() {
        if (this.textureKey == null) {
            this.refreshTextureKey();
        }
        return this.textureKey;
    }

    public void refreshTextureKey() {
        this.textureKey = BlackboardData.pack(this.pixels, (Boolean)this.method_11010().method_11654((class_2769)BlackboardBlock.GLOWING), this.waxed);
    }

    public void afterDataPacket(ExtraModelData oldData) {
        this.refreshTextureKey();
        super.afterDataPacket(oldData);
    }

    public void method_5431() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.loadOwner(tag);
        this.waxed = tag.method_10545("Waxed") && tag.method_10577("Waxed");
        this.pixels = new byte[16][16];
        if (tag.method_10545("Pixels")) {
            this.pixels = BlackboardData.unpackPixels(tag.method_10565("Pixels"));
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.saveOwner(tag);
        if (this.waxed) {
            tag.method_10556("Waxed", true);
        }
        tag.method_10564("Pixels", BlackboardData.packPixels(this.pixels));
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        if (!this.isEmpty()) {
            components.method_57840(ModComponents.BLACKBOARD.get(), (Object)this.getTextureKey());
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        BlackboardData data = (BlackboardData)componentInput.method_58694(ModComponents.BLACKBOARD.get());
        if (data != null) {
            this.waxed = data.waxed();
            this.pixels = data.unpackPixels();
        } else {
            this.clearPixels();
        }
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("Waxed");
        tag.method_10551("Pixels");
    }

    public void clearPixels() {
        for (int x = 0; x < this.pixels.length; ++x) {
            for (int y = 0; y < this.pixels[x].length; ++y) {
                this.pixels[x][y] = 0;
            }
        }
    }

    public boolean isEmpty() {
        boolean flag = false;
        byte[][] byArray = this.pixels;
        int n = byArray.length;
        block0: for (int i = 0; i < n; ++i) {
            byte[] pixel;
            for (byte b : pixel = byArray[i]) {
                if (b == 0) continue;
                flag = true;
                continue block0;
            }
        }
        return !flag;
    }

    public void setPixel(int x, int y, byte b) {
        this.pixels[x][y] = b;
    }

    public byte getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public void setPixels(byte[][] pixels) {
        this.pixels = pixels;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)NoticeBoardBlock.FACING);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void openScreen(class_1937 level, class_2338 blockPos, class_1657 player, class_2350 direction) {
        BlackBoardScreen.open(this);
    }

    @Override
    public void setWaxed(boolean b) {
        this.waxed = b;
    }

    @Override
    public boolean isWaxed() {
        return this.waxed;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    @Override
    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public boolean tryAcceptingClientPixels(class_3222 player, byte[][] pixels) {
        if (!this.isEditingPlayer((class_1657)player)) {
            Supplementaries.LOGGER.warn("Player {} just tried to change non-editable blackboard block", (Object)player.method_5477().getString());
        }
        if (!Arrays.deepEquals((Object[])pixels, (Object[])this.pixels)) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.BLACKBOARD_DRAW.get(), class_3419.field_15245, 1.0f, 1.0f);
            this.setPlayerWhoMayEdit(null);
            this.setPixels(pixels);
            return true;
        }
        return false;
    }
}

