/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.dynamicpack.ServerDynamicResourcesGenerator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_799;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Collection<String> additionalNamespaces() {
        return List.of("minecraft");
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        Respriter respriter;
        TextureImage template;
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
        ColoredMapHandler.onResourceReload();
        SlimedRenderTypes.clear();
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            try (TextureImage text2 = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60656((String)"entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60656((String)"entity/enderman/enderman_eyes"));){
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/enderman_head"), text2, false);
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText, false);
            }
            catch (Exception text2) {
                // empty catch block
            }
        }
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)class_2960.method_60656((String)"crossbow"), e -> e.add(new class_799(class_2960.method_60656((String)"item/crossbow_rope_arrow"), List.of(new class_799.class_5826(class_2960.method_60656((String)"charged"), 1.0f), new class_799.class_5826(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)class_2960.method_60656((String)"written_book"), e -> e.add(new class_799(class_2960.method_60656((String)"item/written_book_tattered"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)class_2960.method_60656((String)"filled_map"), e -> e.add(new class_799(class_2960.method_60656((String)"item/antique_map"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
        }
        RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)Supplementaries.res("globe"), e -> {
            int i = 0;
            for (class_2960 text : GlobeManager.TEXTURES) {
                String name = text.method_12832().split("/")[3].split("\\.")[0];
                e.add(new class_799(Supplementaries.res("item/" + name), List.of(new class_799.class_5826(Supplementaries.res("type"), (float)i))));
                ++i;
                ((DynamicTexturePack)this.dynamicPack).addItemModel(Supplementaries.res(name), JsonParser.parseString((String)("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"supplementaries:item/globes/" + name + "\"    }\n}\n")));
            }
        });
        StaticResource spItemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Supplementaries.res("way_sign_oak")));
        StaticResource spBlockModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Supplementaries.res("way_signs/way_sign_oak")));
        ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((class_1792)sign).method_12832();
            try {
                this.addSimilarJsonResource(manager, spItemModel, "way_sign_oak", id);
                this.addSimilarJsonResource(manager, spBlockModel, "way_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/way_signs/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("item/way_signs/" + Utils.getID((class_1792)sign).method_12832());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    class_1792 signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)signItem));
                             TextureImage signMask = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                            try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("item/hanging_signs/sign_scribbles_mask"), Supplementaries.res("item/way_signs/scribbles_template"));){
                                newImage.applyOverlay(new TextureImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                            }
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("block/way_signs/way_sign_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("block/way_signs/" + Utils.getID((class_1792)sign).method_12832());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    private static void generateTagTranslations() {
        JsonObject jo = new JsonObject();
        for (Map.Entry<class_2960, class_3298> e : ServerDynamicResourcesGenerator.R.entrySet()) {
            class_2960 id = e.getKey();
            if (!id.method_12836().equals("supplementaries")) continue;
            String path = id.method_12832();
            path = path.replace("tags/", "").replace(".json", "");
            String tr = path.substring(path.lastIndexOf("/") + 1);
            jo.addProperty("supplementaries:" + path, LangBuilder.getReadableName((String)tr));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static TextureImage recolorFromVanilla(class_3300 manager, TextureImage vanillaTexture, class_2960 vanillaMask, class_2960 templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((class_3300)manager, (class_2960)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((class_3300)manager, (class_2960)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.WAY_SIGN_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.way_sign", (BlockType)type, (class_1792)item));
        String bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect");
        if (bambooSpikes == null) {
            return;
        }
        for (class_1842 p : class_7923.field_41179) {
            Optional<class_6880> holder = Optional.of(class_7923.field_41179.method_47983((Object)p));
            String key = class_1842.method_8051(holder, (String)"item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(class_1842.method_8051(holder, (String)"item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((class_1842)p).method_12832())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

