/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.math.random.CompatRandom;
import net.pitan76.mcpitanlib.api.util.world.WorldAccessUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.WorldView;

public class WorldAccess
extends WorldView {
    private final class_1936 world;

    protected WorldAccess(class_1936 world) {
        super(null);
        this.world = world;
    }

    public static WorldAccess of(class_1936 world) {
        return new WorldAccess(world);
    }

    protected class_1936 getRaw() {
        return this.world;
    }

    public class_1936 toMinecraft() {
        return this.getRaw();
    }

    @Override
    public boolean isClient() {
        return WorldAccessUtil.isClient((class_4538)this.getRaw());
    }

    @Override
    public boolean isServer() {
        return !this.isClient();
    }

    public CompatRandom getRandom() {
        return new CompatRandom(this.getRaw().method_8409());
    }

    public MinecraftServer getServer() {
        return WorldAccessUtil.getServer(this.getRaw());
    }

    @Override
    public BlockEntityWrapper getBlockEntity(BlockPos pos) {
        return BlockEntityWrapper.of(WorldAccessUtil.getBlockEntity((class_4538)this.getRaw(), pos.toMinecraft()));
    }

    @Override
    public <T extends class_2586> Optional<T> getRawBlockEntity(BlockPos pos, class_2591<T> type) {
        return WorldAccessUtil.getBlockEntity((class_4538)this.getRaw(), pos.toMinecraft(), type);
    }

    @Override
    public <T extends class_2586> BlockEntityWrapper getBlockEntity(BlockPos pos, class_2591<T> type) {
        Optional<class_2586> blockEntity = WorldAccessUtil.getBlockEntity((class_4538)this.getRaw(), pos.toMinecraft(), type);
        return blockEntity.map(BlockEntityWrapper::of).orElse(BlockEntityWrapper.of());
    }

    public boolean removeBlock(BlockPos pos, boolean move) {
        return WorldAccessUtil.removeBlock(this.getRaw(), pos.toMinecraft(), move);
    }

    public boolean breakBlock(BlockPos pos, boolean drop) {
        return WorldAccessUtil.breakBlock(this.getRaw(), pos.toMinecraft(), drop);
    }

    public boolean breakBlock(BlockPos pos, boolean drop, class_1297 entity) {
        return WorldAccessUtil.breakBlock(this.getRaw(), pos.toMinecraft(), drop, entity);
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        return BlockState.of(WorldAccessUtil.getBlockState(this.getRaw(), pos.toMinecraft()));
    }

    public boolean setBlockState(BlockPos pos, BlockState state, int flags) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft(), flags);
    }

    public boolean setBlockState(BlockPos pos, BlockState state, int flags, int maxUpdateDepth) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft(), flags, maxUpdateDepth);
    }

    public boolean setBlockState(BlockPos pos, BlockState state) {
        return WorldAccessUtil.setBlockState(this.getRaw(), pos.toMinecraft(), state.toMinecraft());
    }

    @Deprecated
    public void playSound(class_1657 playerEntity, class_2338 pos, class_3414 sound, class_3419 category, float volume, float pitch) {
        this.getRaw().method_8396(playerEntity, pos, sound, category, volume, pitch);
    }

    @Deprecated
    public void playSound(class_1657 playerEntity, class_2338 pos, class_3414 sound, class_3419 category) {
        this.getRaw().method_45447(playerEntity, pos, sound, category);
    }

    public void playSound(Player player, BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(player.getEntity(), pos.toMinecraft(), soundEvent.get(), category.get(), volume, pitch);
    }

    public void playSound(Player player, BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(player.getEntity(), pos.toMinecraft(), soundEvent.get(), category.get());
    }

    public void playSound(BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(null, pos.toMinecraft(), soundEvent.get(), category.get(), volume, pitch);
    }

    public void playSound(BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(null, pos.toMinecraft(), soundEvent.get(), category.get());
    }
}

