/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TallCreateSlidingDoorBlock
extends TallDoorBlock {
    protected static final VoxelShape SE_AABB = Block.box((double)0.0, (double)0.0, (double)-13.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB = Block.box((double)-13.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NW_AABB = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0);
    protected static final VoxelShape WN_AABB = Block.box((double)13.0, (double)0.0, (double)13.0, (double)29.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB = Block.box((double)13.0, (double)0.0, (double)-13.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)29.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NE_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)29.0);
    protected static final VoxelShape EN_AABB = Block.box((double)-13.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SE_AABB_FOLD = Block.box((double)0.0, (double)0.0, (double)-3.0, (double)9.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB_FOLD = Block.box((double)-3.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NW_AABB_FOLD = Block.box((double)7.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)19.0);
    protected static final VoxelShape WN_AABB_FOLD = Block.box((double)13.0, (double)0.0, (double)7.0, (double)19.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB_FOLD = Block.box((double)7.0, (double)0.0, (double)-3.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB_FOLD = Block.box((double)13.0, (double)0.0, (double)0.0, (double)19.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NE_AABB_FOLD = Block.box((double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0, (double)19.0);
    protected static final VoxelShape EN_AABB_FOLD = Block.box((double)-3.0, (double)0.0, (double)7.0, (double)3.0, (double)16.0, (double)16.0);
    public static final BooleanProperty VISIBLE = DDBlockStateProperties.VISIBLE;
    private boolean folds = false;

    public TallCreateSlidingDoorBlock(BlockSetType blockset, Block from, boolean isFolding) {
        super(blockset, from);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DDBlockStateProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.folds = isFolding;
    }

    public static VoxelShape getShapeByProperty(Direction facing, boolean hinge, boolean fold) {
        if (fold) {
            return switch (facing) {
                case Direction.SOUTH -> {
                    if (hinge) {
                        yield ES_AABB_FOLD;
                    }
                    yield WS_AABB_FOLD;
                }
                case Direction.WEST -> {
                    if (hinge) {
                        yield SW_AABB_FOLD;
                    }
                    yield NW_AABB_FOLD;
                }
                case Direction.NORTH -> {
                    if (hinge) {
                        yield WN_AABB_FOLD;
                    }
                    yield EN_AABB_FOLD;
                }
                default -> hinge ? NE_AABB_FOLD : SE_AABB_FOLD;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> {
                if (hinge) {
                    yield ES_AABB;
                }
                yield WS_AABB;
            }
            case Direction.WEST -> {
                if (hinge) {
                    yield SW_AABB;
                }
                yield NW_AABB;
            }
            case Direction.NORTH -> {
                if (hinge) {
                    yield WN_AABB;
                }
                yield EN_AABB;
            }
            default -> hinge ? NE_AABB : SE_AABB;
        };
    }

    @Override
    public BlockState updateShape(BlockState state, Direction pFacing, BlockState pFacingState, LevelAccessor level, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState blockState = super.updateShape(state, pFacing, pFacingState, level, pCurrentPos, pFacingPos);
        if (blockState.isAir()) {
            return blockState;
        }
        TripleBlockPart part = (TripleBlockPart)((Object)blockState.getValue((Property)THIRD));
        if (pFacing.getAxis() == Direction.Axis.Y && part == TripleBlockPart.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.is((Block)this) && pFacingState.getValue((Property)THIRD) != part ? (BlockState)blockState.setValue((Property)VISIBLE, (Comparable)((Boolean)pFacingState.getValue((Property)VISIBLE))) : Blocks.AIR.defaultBlockState();
        }
        if (pFacing.getAxis() == Direction.Axis.Y && part == TripleBlockPart.UPPER == (pFacing == Direction.DOWN)) {
            return pFacingState.is((Block)this) && pFacingState.getValue((Property)THIRD) != part ? (BlockState)blockState.setValue((Property)VISIBLE, (Comparable)((Boolean)pFacingState.getValue((Property)VISIBLE))) : Blocks.AIR.defaultBlockState();
        }
        return blockState;
    }

    @Override
    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.is((Block)this)) {
            return;
        }
        if ((Boolean)state.getValue((Property)OPEN) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, changedState, 10);
        DoorHingeSide hinge = (DoorHingeSide)changedState.getValue((Property)HINGE);
        Direction facing = (Direction)changedState.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
        BlockState otherDoor = level.getBlockState(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
            this.setOpen(entity, level, otherDoor, otherPos, open);
        }
        this.playSound(entity, level, pos, open);
        level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)(state = (BlockState)state.cycle((Property)OPEN)).getValue((Property)OPEN)).booleanValue()) {
            state = (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, state, 10);
        level.gameEvent((Entity)player, (Holder)(this.isOpen(state) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)HINGE);
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
        BlockState otherDoor = level.getBlockState(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor(state, hinge, facing, otherDoor)) {
            this.useWithoutItem(otherDoor, level, otherPos, player, hit);
        } else if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_OPEN, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static boolean isDoubleDoor(BlockState state, DoorHingeSide hinge, Direction facing, BlockState otherDoor) {
        return otherDoor.getBlock() == state.getBlock() && otherDoor.getValue((Property)HINGE) != hinge && otherDoor.getValue((Property)FACING) == facing && otherDoor.getValue((Property)OPEN) != state.getValue((Property)OPEN) && otherDoor.getValue((Property)THIRD) == state.getValue((Property)THIRD);
    }

    public static boolean isDoorPowered(Level pLevel, BlockPos pos, BlockState state) {
        boolean lower = state.getValue((Property)THIRD) == TripleBlockPart.LOWER;
        DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)HINGE);
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos otherPos = pos.relative(hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise());
        BlockState otherDoor = pLevel.getBlockState(otherPos);
        if (TallCreateSlidingDoorBlock.isDoubleDoor((BlockState)state.cycle((Property)OPEN), hinge, facing, otherDoor) && (pLevel.hasNeighborSignal(otherPos) || pLevel.hasNeighborSignal(otherPos.relative(lower ? Direction.UP : Direction.DOWN)))) {
            return true;
        }
        return pLevel.hasNeighborSignal(pos) || pLevel.hasNeighborSignal(pos.relative(lower ? Direction.UP : Direction.DOWN));
    }

    public void deferUpdate(LevelAccessor level, BlockPos pos) {
    }

    public boolean isFoldingDoor() {
        return this.folds;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VISIBLE});
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

