/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.neoforge.compat;

import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import com.fizzware.dramaticdoors.neoforge.neoforge.config.DDConfigNF;
import com.fizzware.dramaticdoors.neoforge.tags.DDBlockTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class AutomaticDoorCompat {
    protected static int doorOpenTime = DDConfigNF.getConfigIntValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.doorOpenTime");
    protected static boolean shouldOpenIronDoors = DDConfigNF.getConfigBooleanValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.shouldOpenIronDoors");
    protected static boolean preventOpeningOnSneak = DDConfigNF.getConfigBooleanValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.preventOpeningOnSneak");
    public static HashMap<Level, List<BlockPos>> toclosedoors = new HashMap();
    public static HashMap<Level, List<BlockPos>> newclosedoors = new HashMap();
    private static List<BlockPos> runnables = new ArrayList<BlockPos>();

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        if (!Compats.AUTOMATIC_DOORS_INSTALLED) {
            return;
        }
        Level world = (Level)e.getLevel();
        if (world == null || world.isClientSide) {
            return;
        }
        doorOpenTime = DDConfigNF.getConfigIntValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.doorOpenTime");
        shouldOpenIronDoors = DDConfigNF.getConfigBooleanValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.shouldOpenIronDoors");
        preventOpeningOnSneak = DDConfigNF.getConfigBooleanValue(DDConfigNF.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.preventOpeningOnSneak");
        toclosedoors.put(world, new ArrayList());
        newclosedoors.put(world, new ArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post e) {
        if (!Compats.AUTOMATIC_DOORS_INSTALLED) {
            return;
        }
        Level world = e.getLevel();
        if (world.isClientSide) {
            return;
        }
        if (newclosedoors.size() > 0) {
            toclosedoors.get(world).addAll((Collection<BlockPos>)newclosedoors.get(world));
            newclosedoors.get(world).clear();
        }
        if (toclosedoors.size() > 0) {
            ArrayList<BlockPos> closetoremove = new ArrayList<BlockPos>();
            for (BlockPos bp : toclosedoors.get(world)) {
                if (bp == null) {
                    closetoremove.add(bp);
                    continue;
                }
                BlockState state = world.getBlockState(bp);
                Block block = state.getBlock();
                if (!(block instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state)) {
                    closetoremove.add(bp);
                    continue;
                }
                boolean canclose = true;
                for (Player player : world.getEntitiesOfClass(Player.class, new AABB((double)(bp.getX() - 2), (double)bp.getY(), (double)(bp.getZ() - 2), (double)(bp.getX() + 2), (double)bp.getY(), (double)(bp.getZ() + 2)))) {
                    BlockPos ppos = player.blockPosition();
                    if (!ppos.closerThan((Vec3i)bp, 3.0) || preventOpeningOnSneak && player.isCrouching()) continue;
                    canclose = false;
                    break;
                }
                if (!canclose) continue;
                for (BlockPos aroundpos : BlockPos.betweenClosed((int)(bp.getX() - 1), (int)bp.getY(), (int)(bp.getZ() - 1), (int)(bp.getX() + 1), (int)bp.getY(), (int)(bp.getZ() + 1))) {
                    BlockState aroundstate = world.getBlockState(aroundpos);
                    Block aroundblock = aroundstate.getBlock();
                    if (!(aroundblock instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state)) continue;
                    ((TallDoorBlock)block).setOpen(null, world, aroundstate, aroundpos, false);
                }
                closetoremove.add(bp);
            }
            if (closetoremove.size() > 0) {
                for (BlockPos tr : closetoremove) {
                    toclosedoors.get(world).remove(tr);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post e) {
        Player player = e.getEntity();
        Level world = player.getCommandSenderWorld();
        if (world.isClientSide) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        if (player.isShiftKeyDown() && preventOpeningOnSneak) {
            return;
        }
        BlockPos ppos = player.blockPosition().above().immutable();
        for (BlockPos np : BlockPos.betweenClosed((int)(ppos.getX() - 1), (int)ppos.getY(), (int)(ppos.getZ() - 1), (int)(ppos.getX() + 1), (int)ppos.getY(), (int)(ppos.getZ() + 1))) {
            BlockState state = world.getBlockState(np);
            Block block = state.getBlock();
            if (!(block instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state) || toclosedoors.get(world).contains(np) || newclosedoors.get(world).contains(np)) continue;
            ((TallDoorBlock)block).setOpen((Entity)player, world, state, np, true);
            AutomaticDoorCompat.delayDoorClose(world, np.immutable());
        }
    }

    public static void delayDoorClose(Level world, BlockPos pos) {
        if (pos == null) {
            return;
        }
        if (runnables.contains(pos)) {
            return;
        }
        runnables.add(pos);
        new Thread(() -> {
            try {
                Thread.sleep(doorOpenTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!toclosedoors.get(world).contains(pos) && !newclosedoors.get(world).contains(pos)) {
                newclosedoors.get(world).add(pos);
            }
            runnables.remove(pos);
        }).start();
    }

    private static boolean isDoorHandOpenable(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof TallDoorBlock) {
            if (((TallDoorBlock)block).type().canOpenByHand()) {
                return true;
            }
            if (!((TallDoorBlock)block).type().canOpenByHand() && state.is(DDBlockTags.MOB_INTERACTABLE_TALL_DOORS)) {
                return true;
            }
        }
        return shouldOpenIronDoors;
    }
}

