/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.state.properties;

import com.mojang.math.OctahedralGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;

public enum Orientation implements StringRepresentable
{
    X_POSITIVE("x_positive", Direction.Axis.X),
    X_MIDDLE("x_middle", Direction.Axis.X),
    X_NEGATIVE("x_negative", Direction.Axis.X),
    Z_POSITIVE("z_positive", Direction.Axis.Z),
    Z_MIDDLE("z_middle", Direction.Axis.Z),
    Z_NEGATIVE("z_negative", Direction.Axis.Z),
    Y_POSITIVE("y_positive", Direction.Axis.Y),
    Y_MIDDLE("y_middle", Direction.Axis.Y),
    Y_NEGATIVE("y_negative", Direction.Axis.Y);

    private final String name;
    public final Direction.Axis axis;

    private Orientation(String name, Direction.Axis axis) {
        this.name = name;
        this.axis = axis;
    }

    public boolean isMiddle() {
        return this == X_MIDDLE || this == Z_MIDDLE || this == Y_MIDDLE;
    }

    public boolean isPositive() {
        return this == X_POSITIVE || this == Z_POSITIVE || this == Y_POSITIVE;
    }

    public boolean isNegative() {
        return this == X_NEGATIVE || this == Z_NEGATIVE || this == Y_NEGATIVE;
    }

    public Orientation rotate(Rotation rotation) {
        if (this.axis == Direction.Axis.Y) {
            return this;
        }
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> this.getClockWise();
            case Rotation.CLOCKWISE_180 -> this.getOpposite();
            case Rotation.COUNTERCLOCKWISE_90 -> this.getCounterClockWise();
            default -> this;
        };
    }

    public Orientation mirror(Mirror mirror) {
        OctahedralGroup rotation = mirror.rotation();
        if (rotation == OctahedralGroup.INVERT_X && this.axis == Direction.Axis.X) {
            return this.getOpposite();
        }
        if (rotation == OctahedralGroup.INVERT_Z && this.axis == Direction.Axis.Z) {
            return this.getOpposite();
        }
        if (rotation == OctahedralGroup.INVERT_Y && this.axis == Direction.Axis.Y) {
            return this.getOpposite();
        }
        return this;
    }

    public Orientation getClockWise() {
        return switch (this.ordinal()) {
            case 5 -> X_POSITIVE;
            case 3 -> X_NEGATIVE;
            case 2 -> Z_NEGATIVE;
            case 0 -> Z_POSITIVE;
            case 1 -> Z_MIDDLE;
            case 4 -> X_MIDDLE;
            default -> this;
        };
    }

    public Orientation getCounterClockWise() {
        return switch (this.ordinal()) {
            case 5 -> X_NEGATIVE;
            case 3 -> X_POSITIVE;
            case 2 -> Z_POSITIVE;
            case 0 -> Z_NEGATIVE;
            case 1 -> Z_MIDDLE;
            case 4 -> X_MIDDLE;
            default -> this;
        };
    }

    public Orientation getOpposite() {
        return switch (this.ordinal()) {
            case 5 -> Z_POSITIVE;
            case 3 -> Z_NEGATIVE;
            case 2 -> X_POSITIVE;
            case 0 -> X_NEGATIVE;
            case 6 -> Y_NEGATIVE;
            case 8 -> Y_POSITIVE;
            default -> this;
        };
    }

    public static Orientation getOrientationFrom(BlockPlaceContext context) {
        Direction.Axis axis = context.getClickedFace().getAxis();
        if (axis.isHorizontal()) {
            return Orientation.getYOrientationFrom(context.getClickedPos(), context.getClickLocation());
        }
        if (context.getHorizontalDirection().getAxis() == Direction.Axis.X) {
            return Orientation.getXOrientationFrom(context.getClickedPos(), context.getClickLocation());
        }
        if (context.getHorizontalDirection().getAxis() == Direction.Axis.Z) {
            return Orientation.getZOrientationFrom(context.getClickedPos(), context.getClickLocation());
        }
        return Y_MIDDLE;
    }

    public static Orientation getXZOrientationFrom(BlockPlaceContext context) {
        if (context.getHorizontalDirection().getAxis() == Direction.Axis.X) {
            return Orientation.getXOrientationFrom(context.getClickedPos(), context.getClickLocation());
        }
        if (context.getHorizontalDirection().getAxis() == Direction.Axis.Z) {
            return Orientation.getZOrientationFrom(context.getClickedPos(), context.getClickLocation());
        }
        return Z_MIDDLE;
    }

    private static Orientation getZOrientationFrom(BlockPos clickPosition, Vec3 clickLocation) {
        double p = clickLocation.z - (double)clickPosition.getZ();
        if (p > 0.6666666666666666) {
            return Z_POSITIVE;
        }
        if (p > 0.3333333333333333) {
            return Z_MIDDLE;
        }
        return Z_NEGATIVE;
    }

    private static Orientation getXOrientationFrom(BlockPos clickPosition, Vec3 clickLocation) {
        double p = clickLocation.x - (double)clickPosition.getX();
        if (p > 0.6666666666666666) {
            return X_POSITIVE;
        }
        if (p > 0.3333333333333333) {
            return X_MIDDLE;
        }
        return X_NEGATIVE;
    }

    private static Orientation getYOrientationFrom(BlockPos clickPosition, Vec3 clickLocation) {
        double p = clickLocation.y - (double)clickPosition.getY();
        if (p > 0.6666666666666666) {
            return Y_NEGATIVE;
        }
        if (p > 0.3333333333333333) {
            return Y_MIDDLE;
        }
        return Y_POSITIVE;
    }

    public String getSerializedName() {
        return this.name;
    }
}

