/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.picono435.randomtp.api;

import com.gmail.picono435.randomtp.RandomTPMod;
import com.gmail.picono435.randomtp.api.fabric.RandomTPAPIImpl;
import com.gmail.picono435.randomtp.config.Config;
import com.gmail.picono435.randomtp.config.Messages;
import com.mojang.datafixers.util.Pair;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2266;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class RandomTPAPI {
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);

    public static Future<Boolean> randomTeleport(class_3222 player, class_3218 world) {
        return RandomTPAPI.randomTeleport(player, world, null);
    }

    public static Future<Boolean> randomTeleport(class_3222 player, class_3218 world, class_5321<class_1959> biomeResourceKey) {
        return executorService.submit(() -> {
            try {
                Random random = new Random();
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                if (biomeResourceKey == null) {
                    Pair<Integer, Integer> coordinates = RandomTPAPI.generateCoordinates(world, (class_1657)player, random);
                    int x = (Integer)coordinates.getFirst();
                    int z = (Integer)coordinates.getSecond();
                    mutableBlockPos.method_33097(x);
                    mutableBlockPos.method_33098(50);
                    mutableBlockPos.method_33099(z);
                } else {
                    Pair pair = world.method_42108(biomeHolder -> biomeHolder.method_40225(biomeResourceKey), player.method_23312(), 6400, 32, 64);
                    if (pair == null) {
                        class_5250 msg = class_2561.method_43470((String)Messages.getMaxTries().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("&", "\u00a7"));
                        player.method_43502((class_2561)msg, false);
                        return false;
                    }
                    mutableBlockPos.method_33097(((class_2338)pair.getFirst()).method_10263());
                    mutableBlockPos.method_33098(50);
                    mutableBlockPos.method_33099(((class_2338)pair.getFirst()).method_10260());
                    if (!world.method_8621().method_11952((class_2338)mutableBlockPos)) {
                        class_5250 msg = class_2561.method_43470((String)Messages.getMaxTries().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("&", "\u00a7"));
                        player.method_43502((class_2561)msg, false);
                        return false;
                    }
                }
                int maxTries = Config.getMaxTries();
                int y = mutableBlockPos.method_10264();
                while (!(RandomTPAPI.isSafe(world, mutableBlockPos) || maxTries != -1 && maxTries <= 0)) {
                    mutableBlockPos.method_33098(++y);
                    if (mutableBlockPos.method_10264() >= 200 || !RandomTPAPI.isInBiomeWhitelist(((class_5321)world.method_23753(mutableBlockPos.method_10062()).method_40230().get()).method_29177())) {
                        if (biomeResourceKey != null) {
                            Pair pair = world.method_42108(biomeHolder -> biomeHolder.method_40225(biomeResourceKey), player.method_23312(), 6400, 32, 64);
                            if (pair == null) {
                                class_5250 msg = class_2561.method_43470((String)Messages.getMaxTries().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("&", "\u00a7"));
                                player.method_43502((class_2561)msg, false);
                                return false;
                            }
                            mutableBlockPos.method_33097(((class_2338)pair.getFirst()).method_10263());
                            mutableBlockPos.method_33098(50);
                            mutableBlockPos.method_33099(((class_2338)pair.getFirst()).method_10260());
                            if (world.method_8621().method_11952((class_2338)mutableBlockPos)) continue;
                            class_5250 msg = class_2561.method_43470((String)Messages.getMaxTries().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("&", "\u00a7"));
                            player.method_43502((class_2561)msg, false);
                            return false;
                        }
                        Pair<Integer, Integer> coordinates = RandomTPAPI.generateCoordinates(world, (class_1657)player, random);
                        int x = (Integer)coordinates.getFirst();
                        int z = (Integer)coordinates.getSecond();
                        mutableBlockPos.method_33097(x);
                        mutableBlockPos.method_33098(50);
                        mutableBlockPos.method_33099(z);
                        continue;
                    }
                    if (maxTries > 0) {
                        --maxTries;
                    }
                    if (maxTries != 0) continue;
                    class_5250 msg = class_2561.method_43470((String)Messages.getMaxTries().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("&", "\u00a7"));
                    player.method_43502((class_2561)msg, false);
                    return false;
                }
                player.method_5682().method_20493(() -> {
                    player.method_14251(world, (double)mutableBlockPos.method_10263(), (double)mutableBlockPos.method_10264(), (double)mutableBlockPos.method_10260(), player.method_36455(), player.method_36454());
                    class_5250 successful = class_2561.method_43470((String)Messages.getSuccessful().replaceAll("\\{playerName\\}", player.method_5477().getString()).replaceAll("\\{blockX\\}", "" + (int)player.method_19538().field_1352).replaceAll("\\{blockY\\}", "" + (int)player.method_19538().field_1351).replaceAll("\\{blockZ\\}", "" + (int)player.method_19538().field_1350).replaceAll("&", "\u00a7"));
                    player.method_43502((class_2561)successful, false);
                });
                return true;
            }
            catch (Exception ex) {
                RandomTPMod.getLogger().info("Error executing command.");
                ex.printStackTrace();
                return false;
            }
        });
    }

    private static Pair<Integer, Integer> generateCoordinates(class_3218 world, class_1657 player, Random random) {
        int z;
        int x;
        if (random.nextInt(2) == 1) {
            int n = maxDistance = Config.getMaxDistance() == 0 ? (int)world.method_8621().method_11976() : (int)(player.method_23317() + (double)Config.getMaxDistance());
            if ((double)maxDistance < world.method_8621().method_11976()) {
                maxDistance = (int)world.method_8621().method_11976();
            }
            if ((double)(minDistance = (int)(player.method_23317() - (double)Config.getMinDistance())) < world.method_8621().method_11976()) {
                minDistance = (int)(world.method_8621().method_11976() + 10.0);
            }
            if (maxDistance < minDistance) {
                int n2 = maxDistance ^ minDistance;
                minDistance = maxDistance;
                maxDistance = n2 ^ minDistance;
            }
            if (maxDistance == minDistance) {
                --minDistance;
            }
            x = random.nextInt(maxDistance - minDistance) + minDistance;
        } else {
            int n = maxDistance = Config.getMaxDistance() == 0 ? (int)world.method_8621().method_11963() : (int)(player.method_23317() - (double)Config.getMaxDistance());
            if ((double)maxDistance > world.method_8621().method_11963()) {
                maxDistance = (int)world.method_8621().method_11963();
            }
            if ((double)(minDistance = (int)(player.method_23317() + (double)Config.getMinDistance())) > world.method_8621().method_11963()) {
                minDistance = (int)(world.method_8621().method_11963() - 10.0);
            }
            if (maxDistance < minDistance) {
                int n3 = maxDistance ^ minDistance;
                minDistance = maxDistance;
                maxDistance = n3 ^ minDistance;
            }
            if (maxDistance == minDistance) {
                --minDistance;
            }
            x = random.nextInt(maxDistance - minDistance) + minDistance;
        }
        if (random.nextInt(2) == 1) {
            int minDistance;
            int n = maxDistance = Config.getMaxDistance() == 0 ? (int)world.method_8621().method_11958() : (int)(player.method_23321() + (double)Config.getMaxDistance());
            if ((double)maxDistance < world.method_8621().method_11958()) {
                maxDistance = (int)world.method_8621().method_11958();
            }
            if ((double)(minDistance = (int)(player.method_23321() - (double)Config.getMinDistance())) < world.method_8621().method_11958()) {
                minDistance = (int)(world.method_8621().method_11958() + 10.0);
            }
            if (maxDistance < minDistance) {
                int n4 = maxDistance ^ minDistance;
                minDistance = maxDistance;
                maxDistance = n4 ^ minDistance;
            }
            if (maxDistance == minDistance) {
                --minDistance;
            }
            z = random.nextInt(maxDistance - minDistance) + minDistance;
        } else {
            int minDistance;
            int n = maxDistance = Config.getMaxDistance() == 0 ? (int)world.method_8621().method_11977() : (int)(player.method_23321() - (double)Config.getMaxDistance());
            if ((double)maxDistance > world.method_8621().method_11977()) {
                maxDistance = (int)world.method_8621().method_11977();
            }
            if ((double)(minDistance = (int)(player.method_23321() + (double)Config.getMinDistance())) > world.method_8621().method_11977()) {
                minDistance = (int)(world.method_8621().method_11977() - 10.0);
            }
            if (maxDistance < minDistance) {
                int n5 = maxDistance ^ minDistance;
                minDistance = maxDistance;
                maxDistance = n5 ^ minDistance;
            }
            if (maxDistance == minDistance) {
                --minDistance;
            }
            z = random.nextInt(maxDistance - minDistance) + minDistance;
        }
        return new Pair((Object)x, (Object)z);
    }

    public static class_3218 getWorld(String world, MinecraftServer server) {
        try {
            class_2960 resourcelocation = class_2960.method_12829((String)world);
            class_5321 registrykey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)resourcelocation);
            class_3218 worldTo = server.method_3847(registrykey);
            return worldTo;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean checkCooldown(class_3222 player, Map<String, Long> cooldowns) {
        int cooldownTime = Config.getCooldown();
        if (cooldowns.containsKey(player.method_5477().getString())) {
            long secondsLeft = cooldowns.get(player.method_5477().getString()) / 1000L + (long)cooldownTime - System.currentTimeMillis() / 1000L;
            return secondsLeft <= 0L;
        }
        return true;
    }

    public static long getCooldownLeft(class_3222 player, Map<String, Long> cooldowns) {
        int cooldownTime = Config.getCooldown();
        long secondsLeft = cooldowns.get(player.method_5477().getString()) / 1000L + (long)cooldownTime - System.currentTimeMillis() / 1000L;
        return secondsLeft;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasPermission(class_3222 player, String permission) {
        void var1_1;
        return RandomTPAPIImpl.hasPermission(player, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasPermission(class_2168 source, String permission) {
        void var1_1;
        return RandomTPAPIImpl.hasPermission(source, (String)var1_1);
    }

    public static boolean isSafe(class_3218 world, class_2338.class_2339 mutableBlockPos) {
        return RandomTPAPI.isEmpty(world, mutableBlockPos) && !RandomTPAPI.isDangerBlocks(world, mutableBlockPos) && world.method_8621().method_11952((class_2338)mutableBlockPos);
    }

    public static boolean isEmpty(class_3218 world, class_2338.class_2339 mutableBlockPos) {
        return world.method_22347(mutableBlockPos.method_10069(0, 1, 0)) && world.method_22347((class_2338)mutableBlockPos);
    }

    public static boolean isDangerBlocks(class_3218 world, class_2338.class_2339 mutableBlockPos) {
        if (RandomTPAPI.isDangerBlock(world, (class_2338)mutableBlockPos) && RandomTPAPI.isDangerBlock(world, mutableBlockPos.method_10069(0, 1, 0)) && RandomTPAPI.isDangerBlock(world, mutableBlockPos.method_10069(0, -1, 0))) {
            return true;
        }
        return world.method_8320(mutableBlockPos.method_10069(0, -1, 0)).method_26204() == class_2246.field_10124;
    }

    public static boolean isDangerBlock(class_3218 world, class_2338 mutableBlockPos) {
        return world.method_8320(mutableBlockPos).method_26204() instanceof class_2404 || world.method_8320(mutableBlockPos).method_26204() instanceof class_2266;
    }

    private static boolean isInBiomeWhitelist(class_2960 biome) {
        if (Config.useBiomeWhitelist()) {
            if (biome == null) {
                return false;
            }
            return Config.getAllowedBiomes().contains(biome.toString());
        }
        if (biome == null) {
            return true;
        }
        return !Config.getAllowedBiomes().contains(biome.toString());
    }
}

