/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.picono435.randomtp.config;

import com.gmail.picono435.dependencies.spongepowered.configurate.ConfigurationNode;
import com.gmail.picono435.dependencies.spongepowered.configurate.yaml.YamlConfigurationLoader;
import com.gmail.picono435.randomtp.RandomTPMod;
import com.gmail.picono435.randomtp.config.fabric.ConfigHandlerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class ConfigHandler {
    private static ConfigurationNode config;
    private static YamlConfigurationLoader configLoader;
    private static ConfigurationNode messages;
    private static YamlConfigurationLoader messagesLoader;

    public static void loadConfiguration() throws IOException, URISyntaxException {
        URL input = ConfigHandler.class.getClassLoader().getResource("config.yml");
        File to = ConfigHandler.getConfigDirectory().resolve("RandomTP").resolve("config.yml").toFile();
        if (!to.exists()) {
            FileUtils.copyURLToFile((URL)input, (File)to);
        }
        URL input2 = ConfigHandler.class.getClassLoader().getResource("messages.yml");
        File to2 = ConfigHandler.getConfigDirectory().resolve("RandomTP").resolve("messages.yml").toFile();
        if (!to2.exists()) {
            FileUtils.copyURLToFile((URL)input2, (File)to2);
        }
        configLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).url(input)).path(ConfigHandler.getConfigDirectory().resolve("RandomTP").resolve("config.yml"))).build();
        config = configLoader.load();
        messagesLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).url(input2)).path(ConfigHandler.getConfigDirectory().resolve("RandomTP").resolve("messages.yml"))).build();
        messages = messagesLoader.load();
        if (!messages.node("command", "dimensionNotAllowed").isNull()) {
            messages.node("command", "dimension-not-allowed").mergeFrom(messages.node("command", "dimensionNotAllowed"));
            messages.node("command", "dimensionNotAllowed").set(null);
            messagesLoader.save(messages);
            RandomTPMod.getLogger().warn("Migrated config key from dimensionNotAllowed to dimension-not-allowed");
        }
        if (!messages.node("command", "biomeNotAllowed").isNull()) {
            messages.node("command", "biome-not-allowed").mergeFrom(messages.node("command", "biomeNotAllowed"));
            messages.node("command", "biomeNotAllowed").set(null);
            messagesLoader.save(messages);
            RandomTPMod.getLogger().warn("Migrated config key from biomeNotAllowed to biome-not-allowed");
        }
    }

    public static ConfigurationNode getConfig() {
        return config;
    }

    public static ConfigurationNode getMessages() {
        return messages;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return ConfigHandlerImpl.getConfigDirectory();
    }
}

