/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.picture.StoredPicture;
import net.minecraft.class_3222;

public class DownloadQueue {
    private static final DownloadQueue INSTANCE = new DownloadQueue();
    private final Queue<QueuedPicture> queue = new ConcurrentLinkedQueue<QueuedPicture>();
    private ScheduledExecutorService scheduler;

    private DownloadQueue() {
    }

    public void send(class_3222 player, UUID id, StoredPicture picture) {
        this.queue.add(new QueuedPicture(player, id, picture));
    }

    public void start(long intervalMs) {
        if (this.scheduler == null) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.scheduleAtFixedRate(this::processQueue, 0L, intervalMs, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.queue.clear();
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    private void processQueue() {
        QueuedPicture item = this.queue.poll();
        if (item == null || item.recipient.method_14239()) {
            return;
        }
        ByteCollector.split(item.picture.bytes(), 30000, (section, bytesLeft) -> Camerapture.NETWORK.sendToClient(item.recipient, new DownloadPartialPicturePacket(item.id, section, bytesLeft)));
    }

    public static DownloadQueue getInstance() {
        return INSTANCE;
    }

    private record QueuedPicture(class_3222 recipient, UUID id, StoredPicture picture) {
    }
}

