/*
 * Decompiled with CFR 0.152.
 */
package com.github.vini2003.linkart.mixin;

import com.github.vini2003.linkart.api.LinkableMinecart;
import com.github.vini2003.linkart.configuration.LinkartConfiguration;
import com.github.vini2003.linkart.mixin.MinecartAccessor;
import com.github.vini2003.linkart.utility.CartUtils;
import com.github.vini2003.linkart.utility.CollisionUtils;
import com.github.vini2003.linkart.utility.LoadingCarts;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartEntityMixin
extends class_1297
implements LinkableMinecart {
    @Unique
    private static final double SAFE_SPEEDUP_THRESHOLD = 0.4;
    @Unique
    private static final double SMOOTH_SPEEDUP_AMOUNT = 0.2;
    @Unique
    private static final double SAFE_SPEEDUP_DIFFERENCE = 0.02;
    @Unique
    private double lastMovementLength = 0.0;
    @Unique
    private class_1688 linkart$following;
    @Unique
    private class_1688 linkart$follower;
    @Unique
    private UUID linkart$followingUUID;
    @Unique
    private UUID linkart$followerUUID;
    @Unique
    private class_1799 linkart$itemStack = class_1799.field_8037;

    public AbstractMinecartEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Unique
    private double limitMovementLength(double targetMovementLength) {
        boolean isLeading;
        double cartLastMovementLength = this.lastMovementLength;
        boolean bl = isLeading = this.linkart$getFollowing() == null && this.linkart$getFollower() != null;
        if (!isLeading) {
            return targetMovementLength;
        }
        if (targetMovementLength <= 0.4) {
            return targetMovementLength;
        }
        for (class_1688 follower = this.linkart$getFollower(); follower != null; follower = follower.linkart$getFollower()) {
            double followerLastMovementLength = ((AbstractMinecartEntityMixin)follower).lastMovementLength;
            if (!(Math.abs(followerLastMovementLength - cartLastMovementLength) > 0.02)) continue;
            return cartLastMovementLength;
        }
        return Math.min(Math.max(cartLastMovementLength + 0.2, 0.4), targetMovementLength);
    }

    @ModifyArg(method={"moveOnRail"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V", ordinal=0))
    private class_243 modifiedMovement(class_243 movement) {
        if (this.lastMovementLength < movement.method_1033()) {
            double targetMovementLength = movement.method_1033();
            movement = movement.method_1021(this.limitMovementLength(targetMovementLength) / targetMovementLength);
        }
        this.lastMovementLength = movement.method_1033();
        return movement;
    }

    @WrapOperation(method={"moveOnRail"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(DDD)D")})
    private double linkart$skipVelocityClamping(double value, double min, double max, Operation<Double> original) {
        if (this.linkart$getFollowing() != null) {
            class_1688 following = this.linkart$getFollowing();
            while (following.linkart$getFollowing() != null) {
                following = following.linkart$getFollowing();
            }
            double parent = ((MinecartAccessor)following).linkart$getMaxSpeed();
            return class_3532.method_15350((double)value, (double)(-parent), (double)parent);
        }
        return (Double)original.call(new Object[]{value, min, max});
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void linkart$tick(CallbackInfo ci) {
        boolean differentDirection;
        if (this.method_37908().method_8608()) {
            return;
        }
        class_1688 cast = (class_1688)this;
        if (this.linkart$getFollowing() == null) {
            return;
        }
        class_243 pos = this.method_19538();
        class_243 pos2 = this.linkart$getFollowing().method_19538();
        double dist = Math.max(Math.abs(pos.method_1022(pos2)) - LinkartConfiguration.distance, 0.0);
        class_243 vec3d = pos.method_1035(pos2);
        vec3d = vec3d.method_1021((double)LinkartConfiguration.velocityMultiplier);
        class_243 vel = this.method_18798();
        class_243 vel2 = this.linkart$getFollowing().method_18798();
        boolean bl = differentDirection = vel.method_1033() > 0.15 && vel2.method_1033() > 0.005 && vel.method_1029().method_1022(vel2.method_1029()) > 1.42 && pos.method_1022(pos2) > 0.5;
        if (differentDirection) {
            dist += LinkartConfiguration.distance;
            vec3d = vel;
        }
        vec3d = vec3d.method_1029().method_1021(dist);
        if (dist <= 1.0) {
            this.method_18799(vec3d.method_1021(0.8 + 0.2 * Math.abs(dist)));
        } else if (dist <= (double)LinkartConfiguration.pathfindingDistance) {
            this.method_18799(vec3d);
        } else {
            CartUtils.unlinkFromParent(cast);
        }
        if (LinkartConfiguration.chunkloading) {
            if (this.linkart$getFollower() != null && !CartUtils.approximatelyZero(this.method_18798().method_1033())) {
                ((class_3218)this.method_37908()).method_14178().method_17297(class_3230.field_19280, this.method_31476(), LinkartConfiguration.chunkloadingRadius, (Object)this.method_24515());
                LoadingCarts.getOrCreate((class_3218)this.method_37908()).addCart(cast);
            } else {
                LoadingCarts.getOrCreate((class_3218)this.method_37908()).removeCart(cast);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"pushAwayFrom"}, cancellable=true)
    void onPushAway(class_1297 entity, CallbackInfo ci) {
        if (!CollisionUtils.shouldCollide(this, entity)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"writeCustomDataToNbt"})
    private void linkart$write(class_2487 nbt, CallbackInfo ci) {
        if (this.linkart$followingUUID != null) {
            nbt.method_25927("LK-Following", this.linkart$followingUUID);
        }
        if (this.linkart$followerUUID != null) {
            nbt.method_25927("LK-Follower", this.linkart$followerUUID);
        }
        if (this.linkart$itemStack != null) {
            nbt.method_10566("LK-ItemStack", this.linkart$itemStack.method_57375((class_7225.class_7874)this.method_56673()));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"readCustomDataFromNbt"})
    private void linkart$read(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("LK-Following")) {
            this.linkart$followingUUID = nbt.method_25926("LK-Following");
        }
        if (nbt.method_10545("LK-Follower")) {
            this.linkart$followerUUID = nbt.method_25926("LK-Follower");
        }
        if (nbt.method_10545("LK-ItemStack")) {
            this.linkart$itemStack = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)nbt.method_10562("LK-ItemStack"));
        }
    }

    @Override
    public class_1688 linkart$getFollowing() {
        if (this.linkart$following == null && this.linkart$followingUUID != null) {
            this.linkart$following = (class_1688)((class_3218)this.method_37908()).method_14190(this.linkart$followingUUID);
        }
        return this.linkart$following;
    }

    @Override
    public void linkart$setFollowing(class_1688 following) {
        this.linkart$following = following;
        this.linkart$followingUUID = following != null ? following.method_5667() : null;
    }

    @Override
    public class_1688 linkart$getFollower() {
        if (this.linkart$follower == null && this.linkart$followerUUID != null) {
            this.linkart$follower = (class_1688)((class_3218)this.method_37908()).method_14190(this.linkart$followerUUID);
        }
        return this.linkart$follower;
    }

    @Override
    public void linkart$setFollower(class_1688 follower) {
        this.linkart$follower = follower;
        this.linkart$followerUUID = follower != null ? follower.method_5667() : null;
    }

    @Override
    public class_1799 linkart$getLinkItem() {
        return this.linkart$itemStack;
    }

    @Override
    public void linkart$setLinkItem(class_1799 linkItem) {
        this.linkart$itemStack = linkItem == null ? class_1799.field_8037 : linkItem;
    }
}

