/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import fuzs.forgeconfigapiport.fabric.impl.client.commands.arguments.ModIdArgument;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_7485;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;

public class FabricConfigCommand {
    private static final Dynamic2CommandExceptionType ERROR_NO_CONFIG = new Dynamic2CommandExceptionType((modId, type) -> class_2561.method_43469((String)"commands.config.noconfig", (Object[])new Object[]{modId, type}));

    public static <T extends Enum<T>, P extends class_2172> void register(CommandDispatcher<P> dispatcher, BiConsumer<P, class_2561> feedbackSender) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").then(RequiredArgumentBuilder.argument((String)"mod", (ArgumentType)new ModIdArgument(){

            @Override
            public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
                return class_2172.method_9264(FabricLoader.getInstance().getAllMods().stream().map(container -> container.getMetadata().getId()).filter(FabricConfigCommand::anyModConfigsExist), (SuggestionsBuilder)builder);
            }
        }).then(RequiredArgumentBuilder.argument((String)"type", FabricConfigCommand.enumConstant(ModConfig.Type.class)).executes(commandContext -> FabricConfigCommand.showFile(component -> feedbackSender.accept((Object)((class_2172)commandContext.getSource()), (class_2561)component), (String)commandContext.getArgument("mod", String.class), (ModConfig.Type)((Object)((Object)commandContext.getArgument("type", ModConfig.Type.class))))))));
    }

    public static <T extends Enum<T>> class_7485<T> enumConstant(Class<? extends T> enumClazz) {
        return new class_7485<T>((Codec)class_3542.method_28140(enumClazz::getEnumConstants), enumClazz::getEnumConstants){};
    }

    private static boolean anyModConfigsExist(String modId) {
        return Stream.of(ModConfig.Type.values()).flatMap(type -> ModConfigs.getConfigFileNames(modId, type).stream()).findAny().isPresent();
    }

    private static <T extends Enum<T>> int showFile(Consumer<class_2561> feedbackSender, String modId, ModConfig.Type type) throws CommandSyntaxException {
        List<String> configFileNames = ModConfigs.getConfigFileNames(modId, type);
        if (configFileNames.isEmpty()) {
            throw ERROR_NO_CONFIG.create((Object)modId, (Object)type.method_15434());
        }
        configFileNames.stream().map(File::new).map(FabricConfigCommand::fileComponent).forEach(component -> feedbackSender.accept((class_2561)class_2561.method_43469((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type.method_15434(), component})));
        return configFileNames.size();
    }

    private static class_2561 fileComponent(File file) {
        return class_2561.method_43470((String)file.getName()).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, file.getAbsolutePath())));
    }

    public static interface ConfigCommandContext<T extends Enum<T>> {
        public String name();

        public Class<T> getType();

        public List<String> getConfigFileNames(String var1, T var2);
    }
}

