/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful;

import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.entity.component.FrostWandRootComponent;
import com.github.thedeathlycow.frostiful.entity.loot.StrayLootTableModifier;
import com.github.thedeathlycow.frostiful.item.FrostedBanner;
import com.github.thedeathlycow.frostiful.item.cloak.AbstractFrostologyCloakItem;
import com.github.thedeathlycow.frostiful.item.event.FrostResistanceProvider;
import com.github.thedeathlycow.frostiful.registry.FArmorMaterials;
import com.github.thedeathlycow.frostiful.registry.FBlocks;
import com.github.thedeathlycow.frostiful.registry.FCriteria;
import com.github.thedeathlycow.frostiful.registry.FEntityAttributes;
import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import com.github.thedeathlycow.frostiful.registry.FFeatures;
import com.github.thedeathlycow.frostiful.registry.FGameRules;
import com.github.thedeathlycow.frostiful.registry.FItemGroups;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.frostiful.registry.FLootConditionTypes;
import com.github.thedeathlycow.frostiful.registry.FParticleTypes;
import com.github.thedeathlycow.frostiful.registry.FPlacedFeatures;
import com.github.thedeathlycow.frostiful.registry.FPotions;
import com.github.thedeathlycow.frostiful.registry.FSoundEvents;
import com.github.thedeathlycow.frostiful.registry.FStatusEffects;
import com.github.thedeathlycow.frostiful.server.command.RootCommand;
import com.github.thedeathlycow.frostiful.server.command.WindCommand;
import com.github.thedeathlycow.frostiful.server.network.PointWindSpawnPacket;
import com.github.thedeathlycow.frostiful.survival.AmbientTemperatureController;
import com.github.thedeathlycow.frostiful.survival.ControllerListeners;
import com.github.thedeathlycow.frostiful.survival.EntityTemperatureController;
import com.github.thedeathlycow.frostiful.survival.ModifyTemperatureController;
import com.github.thedeathlycow.frostiful.survival.SoakingController;
import com.github.thedeathlycow.thermoo.api.armor.material.ArmorMaterialEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frostiful
implements ModInitializer {
    public static final String MODID = "frostiful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"frostiful");
    public static final int CONFIG_VERSION = 2;
    @Nullable
    private static ConfigHolder<FrostifulConfig> configHolder = null;

    public void onInitialize() {
        AutoConfig.register(FrostifulConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(FrostifulConfig.class);
        FrostifulConfig.updateConfig(configHolder);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
                RootCommand.register((CommandDispatcher<class_2168>)dispatcher);
                WindCommand.register((CommandDispatcher<class_2168>)dispatcher);
                FrostedBanner.registerCommand((CommandDispatcher<class_2168>)dispatcher);
            });
        }
        LootTableEvents.MODIFY.register(StrayLootTableModifier::addFrostTippedArrows);
        FArmorMaterials.initialize();
        FBlocks.initialize();
        FItems.initialize();
        FEntityTypes.initialize();
        FGameRules.initialize();
        FSoundEvents.initialize();
        FStatusEffects.initialize();
        FParticleTypes.initialize();
        FPotions.initialize();
        FItemGroups.initialize();
        FLootConditionTypes.initialize();
        FFeatures.initialize();
        FPlacedFeatures.initialize();
        FEntityAttributes.initialize();
        FCriteria.initialize();
        ServerLivingEntityEvents.AFTER_DAMAGE.register(FrostWandRootComponent::afterDamage);
        this.registerThermooEventListeners();
        PayloadTypeRegistry.playS2C().register(PointWindSpawnPacket.PACKET_ID, PointWindSpawnPacket.PACKET_CODEC);
        LOGGER.info("Initialized Frostiful!");
    }

    private void registerThermooEventListeners() {
        ArmorMaterialEvents.GET_FROST_RESISTANCE.register((Object)new FrostResistanceProvider());
        PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.register((change, player) -> {
            boolean doPassiveFreezing;
            if (change > 0) {
                return TriState.DEFAULT;
            }
            FrostifulConfig config = Frostiful.getConfig();
            int tickInterval = config.freezingConfig.getPassiveFreezingTickInterval();
            if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
                return TriState.FALSE;
            }
            if (player.thermoo$getTemperatureScale() < -config.freezingConfig.getMaxPassiveFreezingPercent()) {
                return TriState.FALSE;
            }
            boolean bl = doPassiveFreezing = config.freezingConfig.doPassiveFreezing() && player.method_37908().method_8450().method_8355(FGameRules.DO_PASSIVE_FREEZING);
            if (doPassiveFreezing) {
                return TriState.TRUE;
            }
            return TriState.of((boolean)AbstractFrostologyCloakItem.isWearing(player, stack -> stack.method_31574(FItems.FROSTOLOGY_CLOAK)));
        });
        EnvironmentControllerInitializeEvent.EVENT.register(controller -> new AmbientTemperatureController(FrostifulIntegrations.isModLoaded("scorchful"), controller));
        EnvironmentControllerInitializeEvent.EVENT.register(EnvironmentControllerInitializeEvent.LISTENER_PHASE, ControllerListeners::new);
        EnvironmentControllerInitializeEvent.EVENT.register(EntityTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(EnvironmentControllerInitializeEvent.MODIFY_PHASE, ModifyTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(controller -> FrostifulIntegrations.isModLoaded("scorchful") ? controller : new SoakingController(controller));
    }

    public static FrostifulConfig getConfig() {
        if (configHolder == null) {
            configHolder = AutoConfig.getConfigHolder(FrostifulConfig.class);
        }
        return (FrostifulConfig)configHolder.getConfig();
    }

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }
}

