/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.config.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.HiddenInGui;
import io.github.jamalam360.jamlib.config.Slider;
import io.github.jamalam360.jamlib.config.WithinRange;
import io.github.jamalam360.jamlib.config.gui.ButtonWithTextureWidget;
import io.github.jamalam360.jamlib.config.gui.SelectionList;
import io.github.jamalam360.jamlib.config.gui.SelectionListEntry;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8015;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8494;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigScreen<T>
extends class_437 {
    protected final ConfigManager<T> manager;
    private final class_437 parent;
    private final List<GuiEntry> entries;
    private final List<GuiEntry> changedFields;
    private class_4185 doneButton;

    public ConfigScreen(ConfigManager<T> manager, class_437 parent) {
        super(ConfigScreen.createTitle(manager));
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList<GuiEntry>();
        this.changedFields = new ArrayList<GuiEntry>();
    }

    protected static String createTranslationKey(String modId, String configName, String path) {
        if (modId.equals(configName)) {
            return "config." + modId + "." + path;
        }
        return "config." + modId + "." + configName + "." + path;
    }

    protected static class_2561 createTitle(ConfigManager<?> manager) {
        String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "title");
        if (class_1074.method_4663((String)translationKey)) {
            return class_2561.method_43471((String)translationKey);
        }
        return class_2561.method_43470((String)Platform.getMod((String)manager.getModId()).getName());
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
            this.manager.reloadFromDisk();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46431());
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            if (!this.changedFields.isEmpty()) {
                this.manager.save();
            }
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46431());
        this.method_37063((class_364)new ButtonWithTextureWidget(7, 7, 20, 20, class_2561.method_43471((String)"config.jamlib.edit_manually"), class_2960.method_60656((String)"textures/item/writable_book.png"), 16, 16, button -> {
            if (!this.changedFields.isEmpty()) {
                this.manager.save();
            }
            class_156.method_668().method_672(Platform.getConfigFolder().resolve(this.manager.getConfigName() + ".json5").toFile());
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }));
        ConfigEntryList list = new ConfigEntryList(this.field_22787, this.field_22789, this.field_22790 - 64, 32, 25);
        if (this.entries.isEmpty()) {
            for (Field field : this.manager.getConfigClass().getDeclaredFields()) {
                if (field.isAnnotationPresent(HiddenInGui.class)) continue;
                this.entries.add(new GuiEntry(this.manager.getModId(), this.manager.getConfigName(), field));
            }
        }
        for (GuiEntry entry : this.entries) {
            list.addEntry(entry);
        }
        this.method_37063((class_364)list);
        T entry = this.manager.get();
        if (entry instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)entry;
            List<ConfigExtensions.Link> links = ext.getLinks();
            for (int i = 0; i < links.size(); ++i) {
                ConfigExtensions.Link link = links.get(i);
                this.method_37063((class_364)new ButtonWithTextureWidget(this.field_22789 - 30 - 28 * i, 5, 20, 20, (class_5250)link.getTooltip(), link.getTexture(), 16, 16, button -> {
                    try {
                        class_156.method_668().method_673(link.getUrl().toURI());
                    }
                    catch (Exception e) {
                        JamLib.LOGGER.error("Failed to open link", (Throwable)e);
                    }
                }));
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(class_310.method_1551().field_1772, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
    }

    private boolean canExit() {
        return this.entries.stream().allMatch(GuiEntry::isValid);
    }

    public void method_25393() {
        super.method_25393();
        boolean canExit = this.canExit();
        if (this.doneButton.field_22763 != canExit) {
            this.doneButton.field_22763 = canExit;
        }
    }

    private class ConfigEntryList
    extends SelectionList {
        public ConfigEntryList(class_310 minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
        }

        protected void addEntry(GuiEntry entry) {
            this.method_25321((class_350.class_351)new SelectionListEntry(entry.getName(), entry.getTooltip(), entry.createWidget(ConfigScreen.this.manager, this.field_22758)));
        }
    }

    private class GuiEntry {
        private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
        private final Type type;
        private final String translationKey;
        private final List<class_5481> tooltip;
        private final Field field;
        private final Object initialValue;
        private boolean isValid = true;

        protected GuiEntry(String modId, String configName, Field field) {
            this.type = Type.fromField(field);
            this.field = field;
            this.initialValue = this.getFieldValue(ConfigManager.MANAGERS.get(configName));
            this.translationKey = ConfigScreen.createTranslationKey(modId, configName, field.getName());
            String tooltipTranslationKey = this.translationKey + ".tooltip";
            this.tooltip = class_1074.method_4663((String)tooltipTranslationKey) ? class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)tooltipTranslationKey), 200) : null;
        }

        private static class_2561 getBooleanComponent(boolean v) {
            return class_2561.method_43470((String)(v ? "Yes" : "No")).method_27694(s -> s.method_10977(v ? class_124.field_1060 : class_124.field_1061));
        }

        private static class_2561 getEnumComponent(ConfigManager<?> manager, Field field, Enum<?> enumValue) {
            String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), field.getName() + "." + enumValue.name().toLowerCase());
            if (class_1074.method_4663((String)translationKey)) {
                return class_2561.method_43471((String)translationKey);
            }
            return class_2561.method_43470((String)enumValue.name());
        }

        protected List<class_339> createWidget(ConfigManager<T> manager, int width) {
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            TextureWidget validationIcon = new TextureWidget(width - 212, 0, 20, 20, JamLib.id("textures/gui/validation_warning.png"));
            validationIcon.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.jamlib.requires_restart_tooltip")));
            validationIcon.field_22764 = false;
            widgets.add(validationIcon);
            switch (this.type.ordinal()) {
                case 0: {
                    widgets.add((class_339)class_4185.method_46430((class_2561)GuiEntry.getBooleanComponent(Boolean.TRUE.equals(this.getFieldValue(manager))), button -> {
                        this.setFieldValue(manager, !Boolean.TRUE.equals(this.getFieldValue(manager)));
                        button.method_25355(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                    }).method_46433(width - 188, 0).method_46437(150, 20).method_46431());
                    break;
                }
                case 1: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((class_339)this.createEditBox(widgets, Pattern.compile("^-?\\d*\\.?\\d*$"), Float::parseFloat));
                    break;
                }
                case 2: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((class_339)this.createEditBox(widgets, Pattern.compile("^-?\\d*\\.?\\d*$"), Double::parseDouble));
                    break;
                }
                case 3: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((class_339)this.createEditBox(widgets, Pattern.compile("^-?\\d*$"), Integer::parseInt));
                    break;
                }
                case 4: {
                    if (this.field.isAnnotationPresent(Slider.class)) {
                        widgets.add(this.createSlider(widgets));
                        break;
                    }
                    widgets.add((class_339)this.createEditBox(widgets, Pattern.compile("^-?\\d*$"), Long::parseLong));
                    break;
                }
                case 5: {
                    widgets.add((class_339)this.createEditBox(widgets, null, Function.identity()));
                    break;
                }
                case 6: {
                    EnumButton button2 = new EnumButton(width - 188, 0, 150, 20, class_5244.field_39003.method_27661(), this.field.getType(), b -> {
                        this.setFieldValue(manager, b.getValue());
                        b.method_25355(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                    });
                    button2.setValue(Objects.requireNonNull((Enum)this.getFieldValue(manager)));
                    button2.method_25355(GuiEntry.getEnumComponent(manager, this.field, button2.getValue()));
                    widgets.add((class_339)button2);
                    break;
                }
            }
            widgets.add((class_339)new ButtonWithTextureWidget(width - 30, 0, 20, 20, class_2561.method_43471((String)"config.jamlib.reset"), JamLib.id("textures/gui/reset.png"), 16, 16, button -> {
                this.setFieldValue(manager, this.initialValue);
                ((class_339)widgets.get(1)).method_25355(this.handleUpdatesOnChange(manager, widgets, ConfigScreen.this.changedFields));
                Object patt0$temp = widgets.get(1);
                if (patt0$temp instanceof class_342) {
                    class_342 box = (class_342)patt0$temp;
                    box.method_1852(String.valueOf(this.initialValue));
                } else {
                    Object patt1$temp = widgets.get(1);
                    if (patt1$temp instanceof SliderButton) {
                        SliderButton slider = (SliderButton)((Object)((Object)patt1$temp));
                        slider.setValue(((Number)this.initialValue).doubleValue());
                    }
                }
            }));
            this.validate(manager, widgets);
            return widgets;
        }

        private <V> class_342 createEditBox(List<class_339> widgets, Pattern filter, Function<String, V> parse) {
            class_342 box = new class_342(class_310.method_1551().field_1772, ConfigScreen.this.field_22789 - 188, 0, 150, 20, class_5244.field_39003);
            V value = this.getFieldValue(ConfigScreen.this.manager);
            if (value instanceof Number) {
                Number number = (Number)value;
                box.method_1852(DECIMAL_FORMAT.format(number.doubleValue()));
            } else if (value instanceof String) {
                String string = (String)value;
                box.method_1852(string);
            } else if (value != null) {
                box.method_1852(value.toString());
            } else {
                box.method_1852("");
            }
            if (filter != null) {
                box.method_1890(s -> filter.matcher((CharSequence)s).matches());
            }
            box.method_1863(s -> {
                try {
                    this.setFieldValue(ConfigScreen.this.manager, parse.apply((String)s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                box.method_25355(this.handleUpdatesOnChange(ConfigScreen.this.manager, widgets, ConfigScreen.this.changedFields));
            });
            return box;
        }

        private SliderButton createSlider(List<class_339> widgets) {
            WithinRange rangeAnnot = this.field.getAnnotation(WithinRange.class);
            Number current = (Number)this.getFieldValue(ConfigScreen.this.manager);
            if (current == null) {
                current = rangeAnnot.min();
            }
            SliderButton slider = new SliderButton(ConfigScreen.this.field_22789 - 188, 0, 150, 20, class_5244.field_39003, rangeAnnot.min(), rangeAnnot.max(), current.doubleValue(), s -> {
                this.setFieldValue(ConfigScreen.this.manager, s.getValue());
                s.method_25355(this.handleUpdatesOnChange(ConfigScreen.this.manager, widgets, ConfigScreen.this.changedFields));
            });
            slider.method_25355((class_2561)class_2561.method_43470((String)DECIMAL_FORMAT.format(slider.getValue())));
            return slider;
        }

        private class_2561 handleUpdatesOnChange(ConfigManager<T> manager, List<class_339> widgets, List<GuiEntry> changedFields) {
            Object newValue = this.getFieldValue(manager);
            if (changedFields.contains(this) && this.initialValue.equals(newValue)) {
                changedFields.remove(this);
            } else if (!changedFields.contains(this) && !this.initialValue.equals(newValue)) {
                changedFields.add(this);
            }
            this.validate(manager, widgets);
            Class<?> c = this.field.getType();
            if (c == Boolean.TYPE) {
                return GuiEntry.getBooleanComponent(Boolean.TRUE.equals(newValue));
            }
            if (newValue instanceof Number) {
                Number number = (Number)newValue;
                return class_2561.method_43470((String)DECIMAL_FORMAT.format(number.doubleValue()));
            }
            if (newValue instanceof Enum) {
                Enum enumValue = (Enum)newValue;
                return GuiEntry.getEnumComponent(manager, this.field, enumValue);
            }
            if (newValue instanceof Boolean) {
                Boolean boolValue = (Boolean)newValue;
                return GuiEntry.getBooleanComponent(boolValue);
            }
            if (newValue != null) {
                return class_2561.method_43470((String)newValue.toString());
            }
            return class_2561.method_43470((String)"");
        }

        private void validate(ConfigManager<T> manager, List<class_339> widgets) {
            Object newValue = this.getFieldValue(manager);
            Object t = manager.get();
            if (t instanceof ConfigExtensions) {
                ConfigExtensions ext = (ConfigExtensions)t;
                List<ConfigExtensions.ValidationError> errors = ext.getValidationErrors(manager, new ConfigExtensions.FieldValidationInfo(this.field.getName(), newValue, this.initialValue, this.field));
                errors.sort((o1, o2) -> o2.type().ordinal() - o1.type().ordinal());
                TextureWidget validationIcon = (TextureWidget)widgets.getFirst();
                if (!errors.isEmpty()) {
                    this.isValid = errors.getFirst().type() != ConfigExtensions.ValidationError.Type.ERROR;
                    validationIcon.field_22764 = true;
                    validationIcon.setTexture(errors.getFirst().type().getTexture());
                    validationIcon.method_47400(class_7919.method_47407((class_2561)errors.getFirst().message()));
                } else {
                    this.isValid = true;
                    validationIcon.field_22764 = false;
                }
            }
        }

        protected class_2561 getName() {
            return class_2561.method_43471((String)this.translationKey);
        }

        protected List<class_5481> getTooltip() {
            return this.tooltip;
        }

        protected boolean isValid() {
            return this.isValid;
        }

        @Nullable
        private <V> V getFieldValue(ConfigManager<T> manager) {
            try {
                return (V)this.field.get(manager.get());
            }
            catch (IllegalAccessException e) {
                JamLib.LOGGER.error("Failed to access field for config {}", (Object)manager.getConfigName(), (Object)e);
                return null;
            }
        }

        private <V> void setFieldValue(ConfigManager<T> manager, V v) {
            Object realValue = v;
            if (v instanceof Number) {
                Number n = (Number)v;
                Class<?> c = this.field.getType();
                if (c == Double.TYPE || c == Double.class) {
                    realValue = n.doubleValue();
                } else if (c == Float.TYPE || c == Float.class) {
                    realValue = Float.valueOf(n.floatValue());
                } else if (c == Integer.TYPE || c == Integer.class) {
                    realValue = n.intValue();
                } else if (c == Long.TYPE || c == Long.class) {
                    realValue = n.longValue();
                }
            }
            try {
                this.field.set(manager.get(), realValue);
            }
            catch (IllegalAccessException e) {
                JamLib.LOGGER.error("Failed to access field for config {}", (Object)manager.getConfigName(), (Object)e);
            }
        }

        private static enum Type {
            BOOLEAN,
            FLOAT,
            DOUBLE,
            INTEGER,
            LONG,
            STRING,
            ENUM,
            LIST;


            private static Type fromField(Field field) {
                Class<?> c = field.getType();
                if (c == Boolean.TYPE) {
                    return BOOLEAN;
                }
                if (c == Float.TYPE) {
                    return FLOAT;
                }
                if (c == Double.TYPE) {
                    return DOUBLE;
                }
                if (c == Integer.TYPE) {
                    return INTEGER;
                }
                if (c == Long.TYPE) {
                    return LONG;
                }
                if (c == String.class) {
                    return STRING;
                }
                if (c.isEnum()) {
                    return ENUM;
                }
                if (List.class.isAssignableFrom(c)) {
                    return LIST;
                }
                throw new IllegalArgumentException("Unsupported config type: " + String.valueOf(c));
            }
        }
    }

    private static class EnumButton<E extends Enum<E>>
    extends class_4185 {
        private final Class<E> enumClass;
        private final Consumer<EnumButton<E>> onChange;
        private int index;

        protected EnumButton(int x, int y, int width, int height, class_5250 description, Class<Enum<?>> enumClass, Consumer<EnumButton<E>> onChange) {
            super(x, y, width, height, class_5244.field_39003, b -> {
                ((EnumButton)b).setIndex((((EnumButton)b).index + 1) % ((Enum[])((EnumButton)b).enumClass.getEnumConstants()).length);
                ((EnumButton)b).onChange.accept((EnumButton)b);
            }, s -> description);
            this.enumClass = enumClass;
            this.onChange = onChange;
            this.index = 0;
        }

        private E getValue() {
            return (E)((Enum[])this.enumClass.getEnumConstants())[this.index];
        }

        private void setValue(E value) {
            this.setIndex(((Enum)value).ordinal());
        }

        private void setIndex(int index) {
            this.index = index;
        }
    }

    private static class SliderButton
    extends class_339 {
        private static final class_2960 SLIDER_SPRITE = class_2960.method_60656((String)"widget/slider");
        private static final class_2960 HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_highlighted");
        private static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");
        private static final class_2960 SLIDER_HANDLE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
        private final double min;
        private final double max;
        private final Consumer<SliderButton> onChange;
        protected double value;
        private boolean canChangeValue;

        public SliderButton(int x, int y, int width, int height, class_2561 message, double min, double max, double current, Consumer<SliderButton> onChange) {
            super(x, y, width, height, message);
            this.value = current;
            this.min = min;
            this.max = max;
            this.onChange = onChange;
        }

        private class_2960 getSprite() {
            return this.method_25370() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
        }

        private class_2960 getHandleSprite() {
            return !this.field_22762 && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
        }

        @NotNull
        protected class_5250 method_25360() {
            return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
        }

        public void method_47399(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
            if (this.field_22763) {
                if (this.method_25370()) {
                    narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
                } else {
                    narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
                }
            }
        }

        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_310 minecraft = class_310.method_1551();
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.method_52706(this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            double position = this.value / (this.max - this.min);
            double handleX = (double)this.method_46426() + position * (double)(this.method_25368() - 8);
            guiGraphics.method_52706(this.getHandleSprite(), (int)handleX, this.method_46427(), 8, this.method_25364());
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            int k = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_49604(guiGraphics, minecraft.field_1772, 2, k | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }

        public void method_25348(double d, double e) {
            this.setValueFromMouse(d);
        }

        public void method_25365(boolean bl) {
            super.method_25365(bl);
            if (!bl) {
                this.canChangeValue = false;
            } else {
                class_8015 inputType = class_310.method_1551().method_48186();
                if (inputType == class_8015.field_41778 || inputType == class_8015.field_41780) {
                    this.canChangeValue = true;
                }
            }
        }

        public boolean method_25404(int i, int j, int k) {
            if (class_8494.method_51255((int)i)) {
                this.canChangeValue = !this.canChangeValue;
                return true;
            }
            if (this.canChangeValue) {
                boolean bl;
                boolean bl2 = bl = i == 263;
                if (bl || i == 262) {
                    float f = bl ? -1.0f : 1.0f;
                    double step = (this.max - this.min) / (double)((float)this.field_22758 / 8.0f);
                    this.setValue(class_3532.method_15350((double)(this.value + step * (double)f), (double)this.min, (double)this.max));
                    return true;
                }
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            double position = (d - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8);
            this.setValue(class_3532.method_15350((double)(position * (this.max - this.min) + this.min), (double)this.min, (double)this.max));
        }

        protected void method_25349(double d, double e, double f, double g) {
            this.setValueFromMouse(d);
            super.method_25349(d, e, f, g);
        }

        public void method_25354(class_1144 soundManager) {
        }

        public void method_25357(double d, double e) {
            super.method_25354(class_310.method_1551().method_1483());
        }

        protected double getValue() {
            return this.value;
        }

        private void setValue(double d) {
            double e = this.value;
            this.value = class_3532.method_15350((double)d, (double)this.min, (double)this.max);
            if (e != this.value) {
                this.onChange.accept(this);
            }
        }
    }

    private static class TextureWidget
    extends class_339 {
        private class_2960 texture;

        public TextureWidget(int x, int y, int width, int height, class_2960 texture) {
            super(x, y, width, height, class_5244.field_39003);
            this.texture = texture;
        }

        public boolean method_25405(double d, double e) {
            return this.field_22764 && d >= (double)this.method_46426() && e >= (double)this.method_46427() && d < (double)(this.method_46426() + this.field_22758) && e < (double)(this.method_46427() + this.field_22759);
        }

        public void setTexture(class_2960 texture) {
            this.texture = texture;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            graphics.method_25293(this.texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        }

        protected void method_47399(class_6382 _ignored) {
        }

        public void method_25354(class_1144 _ignored) {
        }

        public boolean method_37303() {
            return false;
        }

        @Nullable
        public class_8016 method_48205(class_8023 _ignored) {
            return null;
        }
    }
}

